/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.analytics;

import com.adobe.cq.sightly.WCMUsePojo;
import design.aem.components.ComponentProperties;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import java.text.MessageFormat;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLayer
extends WCMUsePojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataLayer.class);
    private ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    public void activate() throws Exception {
        this.componentProperties = ComponentsUtil.getNewComponentProperties(this);
        this.componentProperties.put("variantTemplate", "variant.default.html");
        this.componentProperties.put("pagePath", this.getResourcePage().getPath());
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getProperties().get("cq:lastReplicated", (Object)"")))) {
            this.componentProperties.put("effectiveDate", DateFormatUtils.format((Calendar)((Calendar)this.getProperties().get("cq:lastReplicated", (Object)Calendar.getInstance())), (String)"yyyy-MM-dd"));
        } else {
            this.componentProperties.put("effectiveDate", "");
        }
        this.componentProperties.put("contentCountry", this.getResourcePage().getLanguage(false).getDisplayCountry());
        this.componentProperties.put("contentLanguage", this.getResourcePage().getLanguage(false).getDisplayLanguage().toLowerCase());
        try {
            String detailsPath = CommonUtil.findComponentInPage(this.getResourcePage(), CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX);
            if (StringUtils.isNotEmpty((CharSequence)detailsPath)) {
                Resource details = this.getResourceResolver().getResource(detailsPath);
                ValueMap detailsProperties = this.getProperties();
                if (!ResourceUtil.isNonExistingResource((Resource)details)) {
                    detailsProperties = (ValueMap)details.adaptTo(ValueMap.class);
                }
                if (detailsProperties != null) {
                    this.componentProperties.put("pageName", detailsProperties.get("analyticsPageName", (Object)""));
                    this.componentProperties.put("pageType", detailsProperties.get("analyticsPageType", (Object)""));
                    this.componentProperties.put("platform", detailsProperties.get("analyticsPlatform", (Object)"aem"));
                    this.componentProperties.put("abort", detailsProperties.get("analyticsAbort", (Object)"false"));
                    String variant = (String)detailsProperties.get("analyticsVariant", (Object)"default");
                    String variantTemplate = ComponentsUtil.getComponentVariantTemplate(this.getComponent(), MessageFormat.format("variant.{0}.html", variant), this.getSlingScriptHelper());
                    this.componentProperties.put("variantTemplate", variantTemplate);
                }
            } else {
                this.componentProperties.put("detailsMissing", StringUtils.isEmpty((CharSequence)detailsPath));
                LOGGER.error("Data layer detailsPath missing under {}", (Object)this.getResourcePage().getPath());
            }
        }
        catch (Exception ex) {
            LOGGER.error("datalayer: {}", (Throwable)ex);
        }
    }
}

