/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.details;

import com.day.cq.wcm.api.Page;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentDetailsUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ImagesUtil;
import design.aem.utils.components.ResolverUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDetails
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GenericDetails.class);
    private static final String PAGE_META_PROPERTY_FIELDS = "metaPropertyFields";
    protected ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        this.processCommonFields();
    }

    protected void processCommonFields() {
        try {
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getPageImgReferencePath(this.getResourcePage()), "pageImage"));
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "secondaryImage"), "pageSecondaryImage"));
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "bgimage"), "pageBackgroundImage"));
            this.componentProperties.putAll(ImagesUtil.getAssetInfo(this.getResourceResolver(), ImagesUtil.getResourceImagePath(this.getResource(), "thumbnail"), "pageThumbnailImage"));
            this.componentProperties.put("redirectTarget", this.getResourcePage().getProperties().get("redirectTarget", (Object)""));
            this.componentProperties.put("pageImageThumbnail", ImagesUtil.getBestFitRendition((String)this.componentProperties.get("pageImage", ""), (Integer)this.componentProperties.get("badgeThumbnailWidth", 319), this.getResourceResolver()));
            this.componentProperties.put("pageSecondaryImageThumbnail", ImagesUtil.getBestFitRendition((String)this.componentProperties.get("pageSecondaryImage", ""), (Integer)this.componentProperties.get("badgeThumbnailWidth", 319), this.getResourceResolver()));
            this.componentProperties.put("pageThumbnailImageThumbnail", ImagesUtil.getBestFitRendition((String)this.componentProperties.get("pageThumbnailImage", ""), (Integer)this.componentProperties.get("badgeThumbnailWidth", 319), this.getResourceResolver()));
            String componentBadge = CommonUtil.getBadgeFromSelectors(this.getRequest().getRequestPathInfo().getSelectorString());
            String requestedBadgeTemplate = MessageFormat.format("{0}.html", componentBadge);
            if (StringUtils.isEmpty((CharSequence)componentBadge)) {
                this.componentProperties.put("componentBadgeSelected", false);
                componentBadge = "default";
                requestedBadgeTemplate = MessageFormat.format("badge.{0}.html", componentBadge);
            } else {
                this.componentProperties.put("componentBadgeSelected", true);
            }
            String defaultBadgeTemplate = MessageFormat.format("badge.{0}.html", "default");
            String badgePath = ComponentsUtil.findLocalResourceInSuperComponent(this.getComponent(), requestedBadgeTemplate, this.getSlingScriptHelper());
            if (StringUtils.isEmpty((CharSequence)badgePath)) {
                LOGGER.error("BADGE NOT FOUND badgePath={},requestedBadgeTemplate={}", (Object)badgePath, (Object)requestedBadgeTemplate);
                componentBadge = "default";
                requestedBadgeTemplate = defaultBadgeTemplate;
            }
            this.componentProperties.put("componentBadge", componentBadge);
            this.componentProperties.put("componentBadgeTemplate", requestedBadgeTemplate);
            this.componentProperties.put("bgimage", (Object)ImagesUtil.getBackgroundImageRenditions(this));
            this.componentProperties.putAll((Map<? extends String, ?>)((Object)ComponentDetailsUtil.processBadgeRequestConfig(this.componentProperties, this.getResourceResolver(), (HttpServletRequest)this.getRequest())), true);
            this.componentProperties.evaluateExpressionFields();
            this.componentProperties.putAll(GenericDetails.processBadgeConfig(this.getResourcePage(), this.componentProperties));
            String variant = (String)this.componentProperties.get("variant", "default");
            if (StringUtils.isEmpty((CharSequence)variant)) {
                variant = "default";
            }
            String variantTemplate = MessageFormat.format("variant.{0}.html", variant);
            this.componentProperties.put("variantTemplate", variantTemplate);
            this.componentProperties.put(PAGE_META_PROPERTY_FIELDS, GenericDetails.processPageMetaProperties(this.getResourcePage(), this.getResourceResolver(), this.getRequest(), this.componentProperties));
            this.componentProperties.put("canonicalUrl", ResolverUtil.mappedUrl(this.getResourceResolver(), this.getRequest(), this.getResourcePage().getPath()).concat(".html"));
        }
        catch (Exception ex) {
            LOGGER.error("processCommonFields: could not process fields componentProperties={}, ex={}", (Object)this.componentProperties, (Object)ex);
        }
    }

    public static Map<String, Object> processBadgeConfig(Page page, ComponentProperties componentProperties) {
        HashMap<String, Object> badgeConfig = new HashMap<String, Object>();
        HashMap<String, Object> badgeLinkAttr = new HashMap<String, Object>();
        badgeLinkAttr.put("target", componentProperties.get("linkTarget", ""));
        if (StringUtils.isNotEmpty((CharSequence)CommonUtil.getPageRedirect(page))) {
            badgeLinkAttr.put("external", "true");
        }
        badgeLinkAttr.put("data-layer-track", componentProperties.get("badgeAnalyticsTrack", ""));
        badgeLinkAttr.put("data-layer-location", componentProperties.get("badgeAnalyticsLocation", ""));
        badgeLinkAttr.put("data-layer-label", componentProperties.get("badgeAnalyticsLabel", ""));
        badgeLinkAttr.put("data-layer-componentpath", componentProperties.get("componentInPagePath", ""));
        badgeConfig.put("badgeLinkAttr", badgeLinkAttr);
        HashMap<String, Object> badgeImageAttr = new HashMap<String, Object>();
        badgeImageAttr.put("data-asset-primary-id", componentProperties.get("pageImageId", ""));
        badgeImageAttr.put("data-asset-primary-license", componentProperties.get("pageImageLicenseInfo", ""));
        badgeImageAttr.put("data-asset-secondary-id", componentProperties.get("pageSecondaryImageId", ""));
        badgeImageAttr.put("data-asset-secondary-license", componentProperties.get("pageSecondaryImageLicenseInfo", ""));
        badgeImageAttr.put("width", componentProperties.get("thumbnailWidth", ""));
        badgeImageAttr.put("height", componentProperties.get("thumbnailHeight", ""));
        String pageSecondaryImageThumbnail = (String)componentProperties.get("pageSecondaryImageThumbnail", "");
        if (StringUtils.isNotEmpty((CharSequence)pageSecondaryImageThumbnail)) {
            badgeImageAttr.put("class", "secondary");
            badgeImageAttr.put("data-asset-secondary-src", pageSecondaryImageThumbnail);
        }
        badgeConfig.put("badgeImageAttr", badgeImageAttr);
        String badgeClassAttr = "";
        badgeClassAttr = badgeClassAttr + StringUtils.join((Object[])((Object[])componentProperties.get("cardStyle", new String[0])), (String)" ");
        badgeClassAttr = badgeClassAttr + StringUtils.join((Object[])((Object[])componentProperties.get("titleIcon", new String[0])), (String)" ");
        badgeClassAttr = badgeClassAttr + StringUtils.join((Object[])((Object[])componentProperties.get("cardAdditional", new String[0])), (String)" ");
        badgeConfig.put("badgeClassAttr", badgeClassAttr);
        String badgeClassIconAttr = "";
        badgeClassIconAttr = badgeClassIconAttr + StringUtils.join((Object[])((Object[])componentProperties.get("cardIcon", new String[0])), (String)" ");
        badgeConfig.put("badgeClassIconAttr", badgeClassIconAttr);
        String pageTitle = (String)componentProperties.get("pageTitle", "");
        badgeConfig.put("badgeTitle", pageTitle);
        if (Boolean.parseBoolean((String)componentProperties.get("badgeTitleTrim", ""))) {
            int badgeTitleTrimLengthMax = (Integer)componentProperties.get("badgeTitleTrimLengthMax", 20);
            if (StringUtils.isNotEmpty((CharSequence)pageTitle)) {
                if (pageTitle.length() > badgeTitleTrimLengthMax) {
                    pageTitle = pageTitle.substring(0, badgeTitleTrimLengthMax).concat((String)componentProperties.get("badgeTitleTrimLengthMaxSuffix", "..."));
                }
                badgeConfig.put("badgeTitle", pageTitle);
            }
        }
        String badgeDescription = (String)componentProperties.get("description", "");
        badgeConfig.put("badgeDescription", badgeDescription);
        if (Boolean.parseBoolean((String)componentProperties.get("badgeSummaryTrim", ""))) {
            int badgeSummaryLengthMax = (Integer)componentProperties.get("badgeSummaryLengthMax", 20);
            if (StringUtils.isNotEmpty((CharSequence)badgeDescription)) {
                if (badgeDescription.length() > badgeSummaryLengthMax) {
                    badgeDescription = badgeDescription.substring(0, badgeSummaryLengthMax).concat((String)componentProperties.get("badgeSummaryLengthMaxSuffix", "badgeSummaryLengthMaxSuffix"));
                }
                badgeConfig.put("badgeDescription", badgeDescription);
            }
        }
        return badgeConfig;
    }

    public static Map<String, String> processPageMetaProperties(Page page, ResourceResolver resourceResolver, SlingHttpServletRequest request, ComponentProperties componentProperties) {
        String[] pageMetaPropertyContent;
        HashMap<String, String> newFields = new HashMap<String, String>();
        String[] pageMetaProperty = (String[])componentProperties.get("pageMetaProperty", new String[0]);
        if (pageMetaProperty.length == (pageMetaPropertyContent = (String[])componentProperties.get("pageMetaPropertyContent", new String[0])).length) {
            for (int i = 0; i < pageMetaProperty.length; ++i) {
                String key = pageMetaProperty[i];
                String value = pageMetaPropertyContent[i];
                if (!StringUtils.isNotEmpty((CharSequence)key) && !StringUtils.isNotEmpty((CharSequence)value)) continue;
                newFields.put(key, value);
            }
        }
        if (!newFields.containsKey("og:url")) {
            newFields.put("og:url", ResolverUtil.mappedUrl(resourceResolver, request, page.getPath()).concat(".html"));
        }
        if (!newFields.containsKey("og:image")) {
            newFields.put("og:image", ResolverUtil.mappedUrl(resourceResolver, request, ImagesUtil.getThumbnailUrl(page, resourceResolver)));
        }
        if (!newFields.containsKey("og:title")) {
            newFields.put("og:title", (String)componentProperties.get("pageTitle", ""));
        }
        if (!newFields.containsKey("og:description")) {
            newFields.put("og:description", ComponentsUtil.getPageDescription(page));
        }
        return newFields;
    }
}

