/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.details;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import design.aem.components.ComponentProperties;
import design.aem.models.v2.details.GenericDetails;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentDetailsUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationDetails
extends GenericDetails {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LocationDetails.class);

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_I18N_CATEGORY = "location-detail";
        String DEFAULT_I18N_LABEL = "variantHiddenLabel";
        String DEFAULT_TITLE = CommonUtil.getPageTitle(this.getResourcePage(), this.getResource());
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"title", DEFAULT_TITLE, "data-title"}, {"latitude", 0.0, "data-latitude"}, {"longitude", 0.0, "data-longitude"}, {"description", ComponentsUtil.getPageDescription(this.getResourcePage()), "data-description"}, {"pages", new String[0]}, {"cq:tags", TagUtil.getPageTags(this.getResourcePage())}, {"pageUrl", CommonUtil.getPageUrl(this.getResourcePage())}, {"pageTitle", DEFAULT_TITLE}, {"pageNavTitle", CommonUtil.getPageNavTitle(this.getResourcePage())}, {"variantHiddenLabel", I18nUtil.getDefaultLabelIfEmpty("", "location-detail", "variantHiddenLabel", "location-detail", i18n, new String[0])}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
        String[] tags = (String[])this.componentProperties.get("cq:tags", new String[0]);
        this.componentProperties.put("category", TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), tags, this.getRequest().getLocale()));
        String[] supportedDetails = CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX;
        String[] supportedRoots = CommonUtil.DEFAULT_LIST_PAGE_CONTENT;
        String[] pages = (String[])this.componentProperties.get("pages", new String[0]);
        List<ComponentProperties> pageList = ComponentDetailsUtil.getPageListInfo(ComponentsUtil.getContextObjects(this), this.getPageManager(), this.getResourceResolver(), pages, supportedDetails, supportedRoots, (Integer)0, (Boolean)true);
        this.componentProperties.put("pageList", pageList);
        try {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.excludeFieldsWithoutExposeAnnotation();
            gsonBuilder.excludeFieldsWithModifiers(new int[]{128});
            ArrayList<String> fieldList = new ArrayList<String>();
            fieldList.add("title");
            fieldList.add("description");
            fieldList.add("category");
            fieldList.add("pageImage");
            fieldList.add("path");
            Gson gson = gsonBuilder.create();
            JsonElement pagesJson = gson.toJsonTree(pageList);
            JsonArray pagesJsonArray = pagesJson.getAsJsonArray();
            if (pagesJsonArray != null && pagesJsonArray.size() > 0) {
                for (int i = 0; i < pagesJsonArray.size(); ++i) {
                    JsonObject object = pagesJsonArray.get(i).getAsJsonObject();
                    List keys = object.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toCollection(ArrayList::new));
                    for (String key : keys) {
                        if (fieldList.contains(key)) continue;
                        object.remove(key);
                    }
                }
                this.componentProperties.put("pagesJson", pagesJson.toString());
                this.componentProperties.attr.add("data-pages", pagesJson.toString());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not convert pageList to Json {}", (Throwable)ex);
        }
        this.processCommonFields();
    }
}

