/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.details;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.i18n.I18n;
import design.aem.components.ComponentProperties;
import design.aem.models.v2.details.GenericDetails;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.I18nUtil;
import design.aem.utils.components.TagUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsDetails
extends GenericDetails {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NewsDetails.class);
    private static final String COMPONENT_DETAILS_NAME = "news-details";
    private static final String DEFAULT_FORMAT_TITLE = "${title}";
    private static final String FIELD_FORMAT_TITLE = "titleFormat";
    private static final String FIELD_FORMATTED_TITLE = "titleFormatted";
    private static final String FIELD_FORMATTED_TITLE_TEXT = "titleFormattedText";

    @Override
    protected void ready() {
        I18n i18n = new I18n((HttpServletRequest)this.getRequest());
        String DEFAULT_ARIA_ROLE = "banner";
        String DEFAULT_TITLE_TAG_TYPE = "h1";
        String DEFAULT_I18N_CATEGORY = "news-detail";
        String DEFAULT_I18N_LABEL = "variantHiddenLabel";
        String DEFAULT_TITLE = CommonUtil.getPageTitle(this.getResourcePage(), this.getResource());
        String DEFAULT_DESCRIPTION = this.getResourcePage().getDescription();
        String DEFAULT_SUBTITLE = (String)this.getResourcePage().getProperties().get("subtitle", (Object)"");
        Boolean DEFAULT_HIDE_TITLE = false;
        Boolean DEFAULT_HIDE_DESCRIPTION = false;
        Boolean DEFAULT_SHOW_BREADCRUMB = true;
        Boolean DEFAULT_SHOW_TOOLBAR = true;
        Boolean DEFAULT_SHOW_PAGE_DATE = true;
        Boolean DEFAULT_SHOW_PARSYS = true;
        this.setComponentFields(new Object[][]{{"variant", "default"}, {"title", DEFAULT_TITLE}, {FIELD_FORMAT_TITLE, ""}, {"description", DEFAULT_DESCRIPTION}, {"hideDescription", DEFAULT_HIDE_DESCRIPTION}, {"hideTitle", DEFAULT_HIDE_TITLE}, {"showBreadcrumb", DEFAULT_SHOW_BREADCRUMB}, {"showToolbar", DEFAULT_SHOW_TOOLBAR}, {"showPageDate", DEFAULT_SHOW_PAGE_DATE}, {"showParsys", DEFAULT_SHOW_PARSYS}, {"linkTarget", "", "target"}, {"pageUrl", CommonUtil.getPageUrl(this.getResourcePage())}, {"pageTitle", DEFAULT_TITLE}, {"pageNavTitle", CommonUtil.getPageNavTitle(this.getResourcePage())}, {"subtitle", DEFAULT_SUBTITLE}, {"cq:tags", new String[0]}, {"ariaRole", "banner", "role"}, {"titleType", "h1", ""}, {"variantHiddenLabel", I18nUtil.getDefaultLabelIfEmpty("", "news-detail", "variantHiddenLabel", "news-detail", i18n, new String[0])}, {"author", ""}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
        Calendar publishDate = (Calendar)this.getProperties().get("publishDate", this.getResourcePage().getProperties().get("jcr:created", (Object)Calendar.getInstance()));
        this.componentProperties.put("publishDate", publishDate);
        String dateFormatString = i18n.get("publishDateFormat", "news-detail");
        String dateDisplayFormatString = i18n.get("publishDateDisplayFormat", "news-detail");
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
        String publishDateText = dateFormat.format(publishDate.getTime());
        dateFormat = new SimpleDateFormat(dateDisplayFormatString);
        String publishDisplayDateText = dateFormat.format(publishDate.getTime());
        this.componentProperties.put("publishDateText", publishDateText);
        this.componentProperties.put("publishDisplayDateText", publishDisplayDateText);
        String newsDateStatusText = i18n.get("newsDateStatusText", "news-detail", new Object[]{publishDateText, publishDisplayDateText});
        this.componentProperties.put("newsDateStatusText", newsDateStatusText);
        String[] tags = (String[])this.componentProperties.get("cq:tags", new String[0]);
        this.componentProperties.put("category", TagUtil.getTagsAsAdmin(this.getSlingScriptHelper(), tags, this.getRequest().getLocale()));
        this.processCommonFields();
        this.componentProperties.putAll(this.processComponentFields(this.componentProperties, i18n, this.getSlingScriptHelper()), false);
    }

    public Map<String, Object> processComponentFields(ComponentProperties componentProperties, I18n i18n, SlingScriptHelper sling) {
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        try {
            String formattedTitle = ComponentsUtil.compileComponentMessage(FIELD_FORMAT_TITLE, DEFAULT_FORMAT_TITLE, componentProperties, sling);
            Document fragment = Jsoup.parse(formattedTitle);
            String formattedTitleText = fragment.text();
            newFields.put(FIELD_FORMATTED_TITLE, formattedTitle.trim());
            newFields.put(FIELD_FORMATTED_TITLE_TEXT, formattedTitleText.trim());
        }
        catch (Exception ex) {
            LOGGER.error("Could not process component fields in {}", (Object)COMPONENT_DETAILS_NAME);
        }
        return newFields;
    }
}

