/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.lists;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.models.v2.lists.List;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListNav
extends ModelProxy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ListNav.class);
    protected ComponentProperties componentProperties = null;
    private java.util.List<Map<String, Object>> listItems;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(intValues={100})
    private int limit;
    private static final String PN_SOURCE = "listFrom";
    private static final String PN_SOURCE_DEFAULT = Source.STATIC.getValue();
    private static final String PARENT_PATH = "parentPath";
    private static final String STATIC_ITEMS = "pages";
    private static final String DESCENDANT_PATH = "ancestorPath";
    private String PARENT_PATH_DEFAULT = "/content";
    private static final String LIMIT_PROPERTY_NAME = "limit";
    private static final int LIMIT_DEFAULT = 100;
    private static final String PN_SORT_ORDER = "sortOrder";
    private static final String PN_ORDER_BY = "orderBy";
    private static final String PN_ORDER_BY_DEFAULT = "path";
    private static final String LIST_ISEMPTY = "isEmpty";
    private static final String FIELD_IMAGE_OPTION_DEFAULT = "responsive";
    private static final String LIST_SEARCH_TYPE = "type";
    private static final String LIST_SEARCH_TYPE_DEFAULT = "cq:Page";
    private static final String LIST_LOOP = "listloop";
    private static final boolean LIST_LOOP_DEFAULT = false;
    private static final String DETAILS_BADGE = "detailsBadge";
    private long totalMatches;
    private List.SortOrder sortOrder;
    private boolean listLoop = false;
    private Page filterPage;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String detailsBadge;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() {
        this.PARENT_PATH_DEFAULT = this.getCurrentPage().getPath();
        this.setComponentFields(new Object[][]{{"variant", "default"}, {STATIC_ITEMS, new String[0]}, {DESCENDANT_PATH, this.PARENT_PATH_DEFAULT}, {PN_SOURCE, PN_SOURCE_DEFAULT}, {PARENT_PATH, this.PARENT_PATH_DEFAULT}, {PN_ORDER_BY, ""}, {LIMIT_PROPERTY_NAME, 100}, {PN_SORT_ORDER, List.SortOrder.ASC.getValue()}, {"imageOption", FIELD_IMAGE_OPTION_DEFAULT}, {LIST_LOOP, false}, {"filterPage", ""}, {DETAILS_BADGE, "default", "data-badge"}});
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY});
        this.sortOrder = List.SortOrder.fromString((String)this.componentProperties.get(PN_SORT_ORDER, List.SortOrder.ASC.getValue()));
        this.limit = (Integer)this.componentProperties.get(LIMIT_PROPERTY_NAME, 100);
        this.listLoop = (Boolean)this.componentProperties.get(LIST_LOOP, false);
        this.detailsBadge = (String)this.componentProperties.get(DETAILS_BADGE, "default");
        String filterPagePage = (String)this.componentProperties.get("filterPage", "");
        this.filterPage = StringUtils.isNotEmpty((CharSequence)filterPagePage) ? this.getPageManager().getPage(filterPagePage) : this.getCurrentPage();
    }

    protected Source getListType() {
        if (this.componentProperties != null) {
            String listFromValue = (String)this.componentProperties.get(PN_SOURCE, this.getCurrentStyle().get(PN_SOURCE, (Object)""));
            return Source.fromString(listFromValue);
        }
        return Source.STATIC;
    }

    public Collection<Map<String, Object>> getListItems() {
        if (this.listItems == null) {
            Source listType = this.getListType();
            this.populateListItems(listType);
        }
        return this.listItems;
    }

    protected void populateListItems(Source listType) {
        switch (listType) {
            case STATIC: {
                this.populateStaticListItems();
                break;
            }
            case CHILDREN: {
                this.populateChildListItems();
                break;
            }
            case DESCENDANTS: {
                this.populateDescendantsListItems();
                break;
            }
            default: {
                this.listItems = new ArrayList<Map<String, Object>>();
            }
        }
        this.componentProperties.put(LIST_ISEMPTY, this.totalMatches == 0L);
    }

    private void populateChildListItems() {
        String path = (String)this.componentProperties.get(PARENT_PATH, this.PARENT_PATH_DEFAULT);
        this.populateChildListItems(path, true);
    }

    private void populateDescendantsListItems() {
        String path = (String)this.componentProperties.get(DESCENDANT_PATH, this.PARENT_PATH_DEFAULT);
        this.populateChildListItems(path, false);
    }

    private void populateChildListItems(String path, Boolean flat) {
        this.listItems = new ArrayList<Map<String, Object>>();
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put(PN_ORDER_BY_DEFAULT, path);
        if (flat.booleanValue()) {
            childMap.put("path.flat", "true");
        } else {
            childMap.put("path.flat", "false");
        }
        childMap.put(LIST_SEARCH_TYPE, LIST_SEARCH_TYPE_DEFAULT);
        this.populateListItemsFromMap(childMap);
    }

    private void populateListItemsFromMap(Map<String, String> map) {
        try {
            QueryBuilder builder = (QueryBuilder)this.getResourceResolver().adaptTo(QueryBuilder.class);
            if (builder != null) {
                Session session = (Session)this.getResourceResolver().adaptTo(Session.class);
                Query query = null;
                map.put("p.limit", String.valueOf(this.limit));
                String orderBy = (String)this.componentProperties.get(PN_ORDER_BY, PN_ORDER_BY_DEFAULT);
                if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
                    map.put("orderby", orderBy);
                } else {
                    map.put("orderby", PN_ORDER_BY_DEFAULT);
                }
                map.put("orderby.sort", this.sortOrder.getValue());
                PredicateGroup root = PredicateGroup.create(map);
                if (!root.isEmpty()) {
                    query = builder.createQuery(root, session);
                }
                if (query != null) {
                    this.collectSearchResults(query.getResult());
                }
            } else {
                LOGGER.error("populateListItemsFromMap: could not get query builder object, map=[{}]", map);
            }
        }
        catch (Exception ex) {
            LOGGER.error("populateListItemsFromMap: could not execute query map=[{}], ex={}", map, (Object)ex);
        }
    }

    private void populateStaticListItems() {
        this.listItems = new ArrayList<Map<String, Object>>();
        String[] items = (String[])this.componentProperties.get(STATIC_ITEMS, new String[0]);
        ResourceResolver resourceResolver = this.getResourceResolver();
        Resource previousResource = null;
        Resource currentResource = null;
        Resource nextResource = null;
        Resource firstResource = null;
        for (String path : items) {
            Resource pathResource = resourceResolver.resolve(path);
            if (!ResourceUtil.isNonExistingResource((Resource)pathResource)) {
                if (firstResource == null) {
                    firstResource = pathResource;
                }
                if (currentResource == null) {
                    if (pathResource.getPath().equals(this.filterPage.getPath())) {
                        currentResource = pathResource;
                        continue;
                    }
                    previousResource = pathResource;
                    continue;
                }
                nextResource = pathResource;
                break;
            }
            LOGGER.error("populateStaticListItems: skipping item as it does not exist {}", (Object)path);
        }
        this.addNavItems(previousResource, currentResource, nextResource, firstResource);
    }

    private void addNavItems(Resource previousResource, Resource currentResource, Resource nextResource, Resource firstResource) {
        if (this.listItems != null) {
            HashMap<String, Object> item;
            if (currentResource != null) {
                if (previousResource != null) {
                    Page previousPage = this.getPageManager().getContainingPage(previousResource);
                    item = new HashMap<String, Object>();
                    item.put("resource", previousResource);
                    item.put(LIST_SEARCH_TYPE, previousResource.getResourceType());
                    item.put("navType", "previous");
                    item.put("page", previousPage);
                    item.putAll(List.getPageBadgeInfo(previousPage, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX, this.getResourceResolver(), this.detailsBadge));
                    this.listItems.add(item);
                }
                if (nextResource != null) {
                    Page nextPage = this.getPageManager().getContainingPage(nextResource);
                    item = new HashMap();
                    item.put("resource", nextResource);
                    item.put(LIST_SEARCH_TYPE, nextResource.getResourceType());
                    item.put("navType", "next");
                    item.put("page", nextPage);
                    item.putAll(List.getPageBadgeInfo(nextPage, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX, this.getResourceResolver(), this.detailsBadge));
                    this.listItems.add(item);
                }
            }
            if ((currentResource == null || this.listLoop && nextResource == null) && firstResource != null) {
                Page firstPage = this.getPageManager().getContainingPage(firstResource);
                item = new HashMap();
                item.put("resource", firstPage);
                item.put(LIST_SEARCH_TYPE, firstResource.getResourceType());
                item.put("navType", "first");
                item.put("page", firstPage);
                item.putAll(List.getPageBadgeInfo(firstPage, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX, this.getResourceResolver(), this.detailsBadge));
                this.listItems.add(item);
            }
        }
    }

    private void collectSearchResults(SearchResult result) throws RepositoryException {
        HashMap<String, Object> resultInfo = new HashMap<String, Object>();
        resultInfo.put("executionTime", result.getExecutionTime());
        resultInfo.put("result", result);
        this.totalMatches = result.getTotalMatches();
        java.util.List resultPages = result.getResultPages();
        long hitsPerPage = result.getHitsPerPage();
        long totalPages = result.getResultPages().size();
        long pageStart = result.getStartIndex();
        long currentPage = pageStart / hitsPerPage + 1L;
        resultInfo.put("hitsPerPage", hitsPerPage);
        resultInfo.put("currentPage", currentPage);
        resultInfo.put("totalMatches", this.totalMatches);
        resultInfo.put("resultPages", resultPages);
        resultInfo.put("totalPages", totalPages);
        this.componentProperties.put("resultInfo", resultInfo);
        Resource previousResource = null;
        Resource currentResource = null;
        Resource nextResource = null;
        Resource firstResource = null;
        for (Hit hit : result.getHits()) {
            if (firstResource == null) {
                firstResource = hit.getResource();
            }
            if (currentResource == null) {
                if (hit.getResource().getPath().equals(this.filterPage.getPath())) {
                    currentResource = hit.getResource();
                    continue;
                }
                previousResource = hit.getResource();
                continue;
            }
            nextResource = hit.getResource();
            break;
        }
        this.addNavItems(previousResource, currentResource, nextResource, firstResource);
    }

    protected static enum Source {
        CHILDREN("children"),
        STATIC("static"),
        DESCENDANTS("descendants"),
        EMPTY("");

        private String value;

        public String getValue() {
            return this.value;
        }

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String value) {
            for (Source s : Source.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }
}

