/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v2.media;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import design.aem.components.ComponentProperties;
import design.aem.models.ModelProxy;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;

public class Video
extends ModelProxy {
    protected ComponentProperties componentProperties = null;

    public ComponentProperties getComponentProperties() {
        return this.componentProperties;
    }

    @Override
    protected void ready() throws Exception {
        Resource assetR;
        this.setComponentFields(new Object[][]{{"lightboxHeight", "70"}, {"lightboxWidth", "70"}, {"thumbnailHeight", "auto"}, {"thumbnailWidth", "auto"}, {"assetTitlePrefix", ""}, {"fileReference", ""}, {"variant", "default"}});
        String msgStart = "";
        String thumbnail = "";
        String metaTitle = "";
        String metaDesc = "";
        String metaCreator = "";
        String metaCopyRight = "";
        this.componentProperties = ComponentsUtil.getComponentProperties((WCMUsePojo)this, (Object[][][])new Object[][][]{this.componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY});
        String fileReference = (String)this.componentProperties.get("fileReference", "");
        Boolean fileReferenceMissing = true;
        this.componentProperties.put("href", fileReference);
        msgStart = (String)this.componentProperties.get("assetTitlePrefix");
        if (StringUtils.isNotEmpty((CharSequence)fileReference) && !ResourceUtil.isNonExistingResource((Resource)(assetR = this.getResourceResolver().resolve(fileReference)))) {
            Asset asset;
            fileReferenceMissing = false;
            Resource fileResource = this.getResourceResolver().getResource(fileReference);
            if (fileResource != null && !ResourceUtil.isNonExistingResource((Resource)fileResource) && (asset = (Asset)fileResource.adaptTo(Asset.class)) != null) {
                String videoWidth = asset.getMetadataValue("tiff:ImageWidth");
                String videoHeight = asset.getMetadataValue("tiff:ImageLength");
                Rendition rd = asset.getRendition("cq5dam.thumb.319.319.png");
                thumbnail = rd == null ? "" : rd.getPath();
                this.componentProperties.put("thumbnail", thumbnail);
                this.componentProperties.put("videoWidth", videoWidth);
                this.componentProperties.put("videoHeight", videoHeight);
                metaTitle = StringUtils.isBlank((CharSequence)asset.getMetadataValue("dc:title")) ? "" : asset.getMetadataValue("dc:title");
                metaDesc = StringUtils.isBlank((CharSequence)asset.getMetadataValue("dc:description")) ? "" : asset.getMetadataValue("dc:description");
                metaCreator = StringUtils.isBlank((CharSequence)asset.getMetadataValue("dc:creator")) ? "" : asset.getMetadataValue("dc:creator");
                metaCopyRight = StringUtils.isBlank((CharSequence)asset.getMetadataValue("dc:rights")) ? "" : "&amp;copy;" + asset.getMetadataValue("dc:rights");
                this.componentProperties.put("msg", msgStart + metaTitle);
                this.componentProperties.put("metaTitle", metaTitle);
                this.componentProperties.put("metaDesc", metaDesc);
                this.componentProperties.put("metaCreator", metaCreator);
                this.componentProperties.put("metaCopyRight", metaCopyRight);
                Node media = CommonUtil.getFirstMediaNode(this.getResourcePage());
                if (media != null && !media.getPath().equals(this.getResource().getPath())) {
                    if (media.hasProperty("lightboxHeight")) {
                        this.componentProperties.put("lightboxHeight", media.getProperty("lightboxHeight").getValue().toString());
                    } else {
                        this.componentProperties.put("lightboxHeight", "");
                    }
                    if (media.hasProperty("lightboxWidth")) {
                        this.componentProperties.put("lightboxWidth", media.getProperty("lightboxWidth").getValue().toString());
                    } else {
                        this.componentProperties.put("lightboxWidth", "");
                    }
                }
                String lightboxWidth = (String)this.componentProperties.get("lightboxWidth", "");
                String lightboxHeight = (String)this.componentProperties.get("lightboxHeight", "");
                this.componentProperties.put("width", videoWidth);
                this.componentProperties.put("height", videoHeight);
                if (StringUtils.isNotEmpty((CharSequence)lightboxWidth)) {
                    this.componentProperties.put("width", lightboxWidth);
                }
                if (StringUtils.isNotEmpty((CharSequence)lightboxWidth)) {
                    this.componentProperties.put("height", lightboxHeight);
                }
            }
        }
        this.componentProperties.put("fileReferenceMissing", fileReferenceMissing);
    }
}

