/*
 * Decompiled with CFR 0.152.
 */
package design.aem.models.v3.content;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import design.aem.components.ComponentProperties;
import design.aem.models.GenericComponent;
import design.aem.models.GenericModel;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ImagesUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={GenericComponent.class, ComponentExporter.class}, resourceType={"aemdesign/components/media/image/v3/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageImpl
extends GenericModel
implements GenericComponent {
    protected static final String RESOURCE_TYPE_V3 = "aemdesign/components/media/image/v3/image";
    protected static final Logger LOGGER = LoggerFactory.getLogger(ImageImpl.class);
    public static final String IMAGE_DELEGATE = "imageDelegate";
    private List<String> hiddenImageResourceProperties = new ArrayList<String>();

    public ImageImpl() {
        this.hiddenImageResourceProperties.add("jcr:title");
        this.hiddenImageResourceProperties.add("jcr:description");
    }

    @Override
    @PostConstruct
    protected void initModel() {
        Resource assetR;
        String DEFAULT_I18N_CATEGORY = "image";
        String DEFAULT_I18N_LABEL_LICENSEINFO = "licenseinfo";
        String DEFAULT_ARIA_ROLE = "banner";
        String FIELD_LINKURL = "linkURL";
        String FIELD_IMAGEURL = "imageURL";
        String FIELD_RENDITIONS = "renditions";
        String DEFAULT_TITLE_TAG_TYPE = "h4";
        Object[][] componentFields = new Object[][]{{"variant", "default"}, {"linkURL", ""}, {"ariaRole", "banner", "role"}, {"titleType", "h4"}};
        this.componentProperties = ComponentsUtil.getComponentProperties((GenericModel)this, (Object[][][])new Object[][][]{componentFields, ComponentsUtil.DEFAULT_FIELDS_STYLE, ComponentsUtil.DEFAULT_FIELDS_ACCESSIBILITY, ComponentsUtil.DEFAULT_FIELDS_ANALYTICS, ImagesUtil.DEFAULT_FIELDS_IMAGE_OPTIONS});
        String fileReference = (String)this.componentProperties.get("fileReference", "");
        Boolean fileReferenceMissing = true;
        if (StringUtils.isNotEmpty((CharSequence)fileReference) && !ResourceUtil.isNonExistingResource((Resource)(assetR = this.getResourceResolver().resolve(fileReference)))) {
            fileReferenceMissing = false;
            AssetManager assetManager = (AssetManager)this.getResourceResolver().adaptTo(AssetManager.class);
            if (assetManager != null) {
                String title;
                com.adobe.granite.asset.api.Asset asset = assetManager.getAsset(fileReference);
                Asset assetBasic = (Asset)assetR.adaptTo(Asset.class);
                Node assetN = (Node)assetR.adaptTo(Node.class);
                String assetUID = asset.getIdentifier();
                String licenseInfo = ImagesUtil.getAssetCopyrightInfo(assetBasic, this.getI18n().get("licenseinfo", "image"));
                this.componentProperties.put("licenseInfo", licenseInfo);
                this.componentProperties.put("asset-id", assetUID);
                ComponentProperties assetProperties = ComponentsUtil.getComponentProperties((GenericModel)this, (Resource)asset, (Object[][][])new Object[][][]{ComponentsUtil.DEFAULT_FIELDS_ASSET_IMAGE});
                this.componentProperties.putAll((Map<? extends String, ?>)((Object)assetProperties), StringUtils.isEmpty((CharSequence)licenseInfo));
                if (StringUtils.isEmpty((CharSequence)licenseInfo)) {
                    ComponentProperties assetPropertiesOverride = ComponentsUtil.getComponentProperties((GenericModel)this, null, (Boolean)false, (Object[][][])new Object[][][]{ComponentsUtil.DEFAULT_FIELDS_ASSET_IMAGE});
                    this.componentProperties.putAll((Map<? extends String, ?>)((Object)assetPropertiesOverride), StringUtils.isEmpty((CharSequence)licenseInfo));
                }
                if (StringUtils.isEmpty((CharSequence)(title = (String)this.componentProperties.get("dc:title", "")))) {
                    this.componentProperties.put("dc:title", assetBasic.getName());
                }
                this.componentProperties.attr.add("data-asset-id", assetUID);
                this.componentProperties.attr.add("data-asset-trackable", Boolean.valueOf(true));
                this.componentProperties.attr.add("data-asset-licensed", Boolean.valueOf(StringUtils.isNotBlank((CharSequence)licenseInfo)));
                this.componentProperties.attr.add("data-analytics-event-label", (String)this.componentProperties.get("dc:title", ""));
                this.componentProperties.attr.add("data-analytics-metatype", assetBasic.getMimeType());
                this.componentProperties.attr.add("data-analytics-filename", assetBasic.getPath());
            } else {
                LOGGER.error("ImageImpl: could not get AssetManager object");
            }
            this.componentProperties.put("componentAttributes", ComponentsUtil.buildAttributesString(this.componentProperties.attr.getData(), null));
            String linkURL = (String)this.componentProperties.get("linkURL", "");
            if (StringUtils.isNotEmpty((CharSequence)linkURL)) {
                Page imageTargetPage = this.getPageManager().getPage(linkURL);
                if (imageTargetPage != null) {
                    linkURL = CommonUtil.getPageUrl(imageTargetPage);
                }
            } else {
                linkURL = (String)this.componentProperties.get("sourceAsset", "");
            }
            this.componentProperties.put("linkURL", linkURL);
            ComponentProperties imageProps = ImagesUtil.getResourceImageRenditions(this.getPageContextMap(), this.getResource(), "renditions", "imageURL");
            Map renditions = (Map)imageProps.get("renditions", new LinkedHashMap());
            if (imageProps.containsKey("imageURL")) {
                this.componentProperties.put("imageURL", imageProps.get("imageURL", ""));
            }
            this.componentProperties.put("renditions", renditions);
        }
        this.componentProperties.put("fileReferenceMissing", fileReferenceMissing);
        String variant = (String)this.componentProperties.get("variant", "");
        if (variant.equals("imageOnly")) {
            variant = "default";
        }
        this.componentProperties.put("variant", variant);
        this.componentProperties.put("variantTemplate", MessageFormat.format("variant.{0}.html", variant));
    }
}

