/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.IncludeOptions;
import design.aem.components.ComponentProperties;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.engine.SlingRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtil.class);
    public static final String COMPONENT_DETAILS_SUFFIX = "-details";
    public static final String PATH_DEFAULT_CONTENT = "article/par";
    public static final String DEFAULT_PAR_NAME = "par";
    public static final String[] DEFAULT_LIST_DETAILS_SUFFIX = new String[]{"-details"};
    public static final String[] DEFAULT_LIST_PAGE_CONTENT = new String[]{"par", "article/par"};
    public static final String DAM_LICENSE_FORMAT = "\u00a9 {4} {0} {1} {2} {3}";
    public static final String DAM_TITLE = "dc:title";
    public static final String DAM_DESCRIPTION = "dc:description";
    public static final String DAM_HEADLINE = "photoshop:Headline";
    public static final String DAM_CREDIT = "photoshop:Credit";
    public static final String DAM_SOURCE = "photoshop:Source";
    public static final String DAM_SOURCE_URL = "sourceAsset";
    public static final String DAM_VIDEO_URL = "sourceVideo";
    public static final String DAM_FIELD_LICENSE_COPYRIGHT_OWNER = "xmpRights:Owner";
    public static final String DAM_FIELD_LICENSE_USAGETERMS = "xmpRights:UsageTerms";
    public static final String DAM_FIELD_LICENSE_EXPIRY = "prism:expirationDate";
    public static final String PN_REDIRECT_TARGET = "cq:redirectTarget";
    public static final String SLING_REDIRECT_TARGET = "sling:redirect";
    public static final String RESOURCE_TYPE = "sling:resourceType";

    public static String escapeBody(Object body) {
        if (body == null) {
            return null;
        }
        return StringEscapeUtils.escapeHtml4((String)body.toString());
    }

    public static String getPageRedirect(Page page) {
        if (page != null && page.getProperties() != null) {
            return (String)page.getProperties().get(PN_REDIRECT_TARGET, page.getProperties().get(SLING_REDIRECT_TARGET, (Object)""));
        }
        return "";
    }

    public static String getPageUrl(Page page) {
        String pageUrl = "#";
        if (page != null) {
            pageUrl = CommonUtil.getPageRedirect(page);
            if (StringUtils.isEmpty((CharSequence)pageUrl)) {
                pageUrl = page.getPath();
            }
            if (pageUrl.startsWith("/content") && !pageUrl.endsWith(".html") && !pageUrl.contains("#") && !pageUrl.contains("?")) {
                pageUrl = pageUrl.concat(".html");
            }
        }
        return CommonUtil.escapeBody(pageUrl);
    }

    public static Long getLastModified(Resource resource) {
        long lastMod = 0L;
        ValueMap values = (ValueMap)resource.adaptTo(ValueMap.class);
        if (values != null) {
            Long value = (Long)values.get("jcr:lastModified", Long.class);
            if (value == null) {
                value = (Long)values.get("jcr:created", Long.class);
            }
            if (value != null) {
                lastMod = value;
            }
        }
        return lastMod;
    }

    public static String getPageDescription(Page page, ValueMap detailsComponentProperties) {
        String pageDescription = "";
        if (detailsComponentProperties != null) {
            pageDescription = (String)detailsComponentProperties.get("description", (Object)"");
        }
        if (StringUtils.isEmpty((CharSequence)pageDescription)) {
            pageDescription = page.getDescription();
        }
        return pageDescription;
    }

    public static String getPageTitle(Page page, Resource detailsComponent) {
        ValueMap dcvm;
        String pageTitle = "";
        if (detailsComponent != null && !ResourceUtil.isNonExistingResource((Resource)detailsComponent) && (dcvm = (ValueMap)detailsComponent.adaptTo(ValueMap.class)) != null) {
            pageTitle = (String)dcvm.get("title", (Object)"");
        }
        if (StringUtils.isEmpty((CharSequence)pageTitle)) {
            return CommonUtil.getPageTitle(page);
        }
        return pageTitle;
    }

    public static String getPageTitle(Page page) {
        String pageTitle = page.getPageTitle();
        if (StringUtils.isEmpty((CharSequence)pageTitle)) {
            pageTitle = page.getTitle();
        }
        if (StringUtils.isEmpty((CharSequence)pageTitle)) {
            pageTitle = page.getName();
        }
        return pageTitle;
    }

    public static String getPageNavTitle(Page page) {
        String pageTitle = page.getNavigationTitle();
        if (StringUtils.isEmpty((CharSequence)pageTitle)) {
            pageTitle = page.getTitle();
        }
        if (StringUtils.isEmpty((CharSequence)pageTitle)) {
            pageTitle = page.getName();
        }
        return pageTitle;
    }

    @Deprecated
    public static String[] getPageContentTypeTag(Page page) {
        if (page == null) {
            return null;
        }
        if (page.getProperties() == null) {
            return null;
        }
        if (!page.getContentResource().getValueMap().containsKey((Object)"cq:tags")) {
            return null;
        }
        return (String[])page.getContentResource().getValueMap().get("cq:tags", (Object)new String[0]);
    }

    public static String getProperty(Node node, String property) throws RepositoryException {
        return CommonUtil.getPropertyWithDefault(node, property, null);
    }

    public static String getPropertyWithDefault(Node node, String property, String defaultValue) throws RepositoryException {
        return StringUtils.defaultString((String)CommonUtil.getSingularPropertyString(node, property), (String)defaultValue);
    }

    public static boolean validDetailComponent(String resourceType) {
        return !StringUtils.isBlank((CharSequence)resourceType) && resourceType.endsWith(COMPONENT_DETAILS_SUFFIX);
    }

    public static boolean nodeExists(Page page, String nodeName) {
        if (page == null || StringUtils.isEmpty((CharSequence)nodeName)) {
            LOGGER.error("nodeExists: page={},nodeName={}", (Object)page, (Object)nodeName);
            return false;
        }
        try {
            Resource pageContent = page.getContentResource();
            if (pageContent == null) {
                LOGGER.error("nodeExists: pageContent={}", (Object)pageContent);
                return false;
            }
            Node pageContentNode = (Node)pageContent.adaptTo(Node.class);
            if (pageContentNode == null) {
                LOGGER.error("nodeExists: pageContentNode={}", (Object)pageContentNode);
                return false;
            }
            Session session = pageContentNode.getSession();
            if (session == null) {
                LOGGER.error("nodeExists: session={}", (Object)session);
                return false;
            }
            if (nodeName.startsWith("/")) {
                nodeName = nodeName.substring(1);
            }
            return pageContentNode.hasNode(nodeName);
        }
        catch (Exception ex) {
            LOGGER.error("nodeExists: ex={}", (Throwable)ex);
            return false;
        }
    }

    public static boolean pageIsOn(Page page) {
        Calendar cal = Calendar.getInstance();
        return !(page.getOffTime() != null && cal.compareTo(page.getOffTime()) > 0 || page.getOnTime() != null && cal.compareTo(page.getOnTime()) < 0);
    }

    public static String hashMd5(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] md5Arr = digest.digest(content.getBytes(StandardCharsets.UTF_8));
            BigInteger bigInt = new BigInteger(1, md5Arr);
            return bigInt.toString(16);
        }
        catch (NoSuchAlgorithmException nsaEx) {
            LOGGER.warn("No MD5 algorithm found, cannot hash");
            return content;
        }
    }

    public static Value getSingularProperty(Node node, String key) {
        try {
            if (node == null || !node.hasProperty(key)) {
                return null;
            }
            Property property = node.getProperty(key);
            if (!property.isMultiple()) {
                return property.getValue();
            }
            Value[] values = property.getValues();
            if (values.length < 1) {
                return null;
            }
            return values[0];
        }
        catch (Exception ex) {
            LOGGER.error("getSingularProperty: ex={0}", (Throwable)ex);
            return null;
        }
    }

    public static String getSingularPropertyString(Node node, String key) throws RepositoryException {
        Value value = CommonUtil.getSingularProperty(node, key);
        return value == null ? null : value.getString();
    }

    public static String findComponentInPage(Page inputPage, String[] resourceTypeTail) {
        return CommonUtil.findComponentInPage(inputPage, resourceTypeTail, new String[]{PATH_DEFAULT_CONTENT});
    }

    public static String findComponentInPage(Page inputPage, String[] resourceTypeTail, String[] pageRoots) {
        if (inputPage == null) {
            return "";
        }
        if (resourceTypeTail == null) {
            resourceTypeTail = DEFAULT_LIST_DETAILS_SUFFIX;
        }
        if (pageRoots == null) {
            pageRoots = new String[]{};
        }
        try {
            String rootPath;
            Resource rootResource = null;
            String[] stringArray = pageRoots;
            int n = stringArray.length;
            for (int i = 0; i < n && (rootResource = inputPage.getContentResource(rootPath = stringArray[i])) == null; ++i) {
            }
            if (rootResource == null) {
                rootResource = inputPage.getContentResource();
            }
            if (rootResource == null) {
                return "";
            }
            NodeIterator nodeIterator = ((Node)rootResource.adaptTo(Node.class)).getNodes();
            if (nodeIterator == null) {
                return "";
            }
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                String checkValue = node.getName();
                if (node.hasProperty(RESOURCE_TYPE)) {
                    checkValue = node.getProperty(RESOURCE_TYPE).getString();
                }
                for (String item : resourceTypeTail) {
                    if (!StringUtils.isNotEmpty((CharSequence)item) || !checkValue.endsWith(item)) continue;
                    return node.getPath();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("findComponentInPage: {}", (Throwable)ex);
            return "";
        }
        return "";
    }

    public static int tryParseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long tryParseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String getComponentNodePath(Page thisPage, String[] nodePaths) {
        if (thisPage == null) {
            return "";
        }
        try {
            Node detailsNode = CommonUtil.getComponentNode(thisPage, nodePaths);
            if (detailsNode != null) {
                return detailsNode.getPath();
            }
        }
        catch (Exception ex) {
            LOGGER.error("getComponentNodePath: {}, {}", (Object)thisPage, (Object)StringUtils.join((Object[])nodePaths));
        }
        return "";
    }

    public static Node getComponentNode(Page thisPage, String[] nodePaths) {
        if (thisPage == null) {
            return null;
        }
        Node detailsNode = null;
        for (String nodePath : nodePaths) {
            Resource detailResource = thisPage.getContentResource(nodePath);
            if (detailResource == null) continue;
            detailsNode = (Node)detailResource.adaptTo(Node.class);
            return detailsNode;
        }
        return null;
    }

    public static Node getComponentNode(Page thisPage, String componentPath) {
        Resource componentResource;
        Node componentDetails = null;
        if (thisPage != null && componentPath != null && (componentResource = thisPage.getContentResource(componentPath)) != null) {
            componentDetails = (Node)componentResource.adaptTo(Node.class);
        }
        return componentDetails;
    }

    public static Node getFirstMediaNode(Page thisPage) {
        Node media;
        block3: {
            media = null;
            try {
                Node par = CommonUtil.getComponentNode(thisPage, PATH_DEFAULT_CONTENT);
                if (par == null) break block3;
                NodeIterator ite = par.getNodes();
                while (ite.hasNext()) {
                    Node node = (Node)ite.next();
                    String type = node.getProperty(RESOURCE_TYPE).getValue().toString();
                    if (type.indexOf("mediagallery") == -1 && type.indexOf("video") == -1) continue;
                    media = node;
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.error("getFirstMediaNode: Could not get media node in page {}, err: {}", (Object)thisPage, (Object)ex);
            }
        }
        return media;
    }

    public static String compileMapMessage(String template, Map<String, Object> map) {
        if (StringUtils.isEmpty((CharSequence)template) || map == null) {
            return "";
        }
        StrSubstitutor sub = new StrSubstitutor(map);
        return sub.replace(template);
    }

    public static String resourceRenderAsHtml(String path, ResourceResolver resourceResolver, SlingScriptHelper sling, WCMMode mode, String requestAttributeName, ComponentProperties requestAttributes, boolean appendHTMLExtention) {
        if (StringUtils.isEmpty((CharSequence)path) || resourceResolver == null || sling == null) {
            String error = MessageFormat.format("resourceRenderAsHtml5: params not specified path=\"{0}\",resourceResolver=\"{1}\",sling=\"{2}\"", path, resourceResolver, sling);
            LOGGER.error(error);
            return "<!--".concat(error).concat("-->");
        }
        try {
            RequestResponseFactory _requestResponseFactory = (RequestResponseFactory)sling.getService(RequestResponseFactory.class);
            SlingRequestProcessor _requestProcessor = (SlingRequestProcessor)sling.getService(SlingRequestProcessor.class);
            if (_requestResponseFactory != null && _requestProcessor != null) {
                String requestUrl = path;
                if (appendHTMLExtention) {
                    requestUrl = path.concat(".html");
                }
                HttpServletRequest _req = _requestResponseFactory.createRequest("GET", requestUrl);
                WCMMode currMode = WCMMode.fromRequest((ServletRequest)_req);
                if (mode != null) {
                    mode.toRequest((ServletRequest)_req);
                } else {
                    WCMMode.DISABLED.toRequest((ServletRequest)_req);
                }
                if (requestAttributes != null && StringUtils.isNotEmpty((CharSequence)requestAttributeName)) {
                    _req.setAttribute(requestAttributeName, (Object)requestAttributes);
                }
                ByteArrayOutputStream _out = new ByteArrayOutputStream();
                HttpServletResponse _resp = _requestResponseFactory.createResponse((OutputStream)_out);
                _requestProcessor.processRequest(_req, _resp, resourceResolver);
                currMode.toRequest((ServletRequest)_req);
                return _out.toString();
            }
            LOGGER.error("resourceRenderAsHtml: could not get objects, _requestResponseFactory={},_requestProcessor={}", (Object)_requestResponseFactory, (Object)_requestProcessor);
            return "<![CDATA[could not get objects]]>";
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred: {}", (Throwable)e);
            return "<![CDATA[" + e.getMessage() + "]]>";
        }
    }

    public static String getBadgeFromSelectors(String selectorString) {
        String badgePattern;
        Pattern pattern;
        Matcher matcher;
        boolean matches;
        String badge = "";
        if (selectorString != null && (matches = (matcher = (pattern = Pattern.compile(badgePattern = "((badge{1,})(.\\w+){0,1})")).matcher(selectorString)).matches())) {
            badge = matcher.group(1);
        }
        return badge;
    }

    public static void forceNoDecoration(ComponentContext componentContext, IncludeOptions includeOptions) {
        componentContext.setDecorate(false);
        componentContext.setDecorationTagName("");
        componentContext.setDefaultDecorationTagName("");
        includeOptions.forceSameContext(Boolean.FALSE.booleanValue()).setDecorationTagName("");
    }

    public static void setDecoration(ComponentContext componentContext, IncludeOptions includeOptions, String defDecoration) {
        componentContext.setDecorate(true);
        componentContext.setDecorationTagName(defDecoration);
        componentContext.setDefaultDecorationTagName(defDecoration);
        includeOptions.forceSameContext(Boolean.FALSE.booleanValue()).setDecorationTagName(defDecoration);
    }

    public static Boolean isNull(Object source) {
        return source == null;
    }

    public static String getUrlContent(String Url) {
        if (StringUtils.isNotEmpty((CharSequence)Url)) {
            try {
                String inputLine;
                URL url = new URL(Url);
                URLConnection conn = url.openConnection();
                BufferedReader bufferReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((inputLine = bufferReader.readLine()) != null) {
                    sb.append(inputLine);
                }
                bufferReader.close();
                return sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }
}

