/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.Rendition;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import design.aem.components.ComponentProperties;
import design.aem.models.GenericModel;
import design.aem.utils.components.CommonUtil;
import design.aem.utils.components.ComponentsUtil;
import design.aem.utils.components.ImagesUtil;
import design.aem.utils.components.TagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDetailsUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ComponentDetailsUtil.class);

    public static List<ComponentProperties> getPageListInfo(WCMUsePojo wcmUsePojoModel, PageManager pageManager, ResourceResolver resourceResolver, String[] paths) {
        try {
            return ComponentDetailsUtil.getPageListInfo(wcmUsePojoModel, pageManager, resourceResolver, paths, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX, CommonUtil.DEFAULT_LIST_PAGE_CONTENT);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(WCMUsePojo) /A1 -> A2 could not read required objects: {}, error: {}", (Object)wcmUsePojoModel, (Object)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(PageContext pageContext, PageManager pageManager, ResourceResolver resourceResolver, String[] paths) {
        try {
            return ComponentDetailsUtil.getPageListInfo(pageContext, pageManager, resourceResolver, paths, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX, CommonUtil.DEFAULT_LIST_PAGE_CONTENT);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(PageContext) A1 -> A2 PageContext could not read required objects {}", (Throwable)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(WCMUsePojo wcmUsePojoModel, PageManager pageManager, ResourceResolver resourceResolver, String[] paths, String[] componentNames, String[] pageRoots) {
        try {
            return ComponentDetailsUtil.getPageListInfo(wcmUsePojoModel, pageManager, resourceResolver, paths, componentNames, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(WCMUsePojo) A2 -> A3 could not read required objects: {}, error: {}", (Object)wcmUsePojoModel, (Object)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(PageContext pageContext, PageManager pageManager, ResourceResolver resourceResolver, String[] paths, String[] componentNames, String[] pageRoots) {
        try {
            return ComponentDetailsUtil.getPageListInfo(pageContext, pageManager, resourceResolver, paths, componentNames, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(PageContext) A2 -> A3 PageContext could not read required objects {}", (Throwable)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(WCMUsePojo wcmUsePojoModel, PageManager pageManager, ResourceResolver resourceResolver, String[] paths, String[] componentNames, String[] pageRoots, Integer collectChildrenFromRoot, Boolean ignoreHidden) {
        try {
            return ComponentDetailsUtil.getPageListInfo(ComponentsUtil.getContextObjects(wcmUsePojoModel), pageManager, resourceResolver, paths, componentNames, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(WCMUsePojo) A3 could not read required objects: {},error={},pageManager={},resourceResolver={},pageList={},detailsComponentName={},pageRoots={}", new Object[]{wcmUsePojoModel, ex, pageManager, resourceResolver, paths, componentNames, pageRoots});
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(PageContext pageContext, PageManager pageManager, ResourceResolver resourceResolver, String[] paths, String[] componentNames, String[] pageRoots, Integer collectChildrenFromRoot, Boolean ignoreHidden) {
        try {
            return ComponentDetailsUtil.getPageListInfo(ComponentsUtil.getContextObjects(pageContext), pageManager, resourceResolver, paths, componentNames, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(PageContext) A3 PageContext could not read required objects {}", (Throwable)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(Map<String, Object> pageContext, PageManager pageManager, ResourceResolver resourceResolver, String[] paths, String[] componentNames, String[] pageRoots, Integer collectChildrenFromRoot, Boolean ignoreHidden) {
        ArrayList<ComponentProperties> pages = new ArrayList<ComponentProperties>();
        for (String path : paths) {
            Page child = pageManager.getPage(path);
            if (child == null || ignoreHidden.booleanValue() && child.isHideInNav()) continue;
            pages.add(ComponentDetailsUtil.getPageInfo(pageContext, child, resourceResolver, componentNames, pageRoots, collectChildrenFromRoot));
        }
        return pages;
    }

    public static List<ComponentProperties> getPageListInfo(WCMUsePojo wcmUsePojoModel, PageManager pageManager, ResourceResolver resourceResolver, Iterator<Page> pageList) {
        try {
            return ComponentDetailsUtil.getPageListInfo(wcmUsePojoModel, pageManager, resourceResolver, pageList, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX, CommonUtil.DEFAULT_LIST_PAGE_CONTENT);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(WCMUsePojo) B1 -> B2 could not read required objects: {}, error: {}", (Object)wcmUsePojoModel, (Object)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(PageContext pageContext, PageManager pageManager, ResourceResolver resourceResolver, Iterator<Page> pageList) {
        try {
            return ComponentDetailsUtil.getPageListInfo(pageContext, pageManager, resourceResolver, pageList, CommonUtil.DEFAULT_LIST_DETAILS_SUFFIX, CommonUtil.DEFAULT_LIST_PAGE_CONTENT);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(PageContext) B1 -> B2 PageContext could not read required objects {}", (Throwable)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(WCMUsePojo wcmUsePojoModel, PageManager pageManager, ResourceResolver resourceResolver, Iterator<Page> pageList, String[] detailsComponentName, String[] pageRoots) {
        try {
            return ComponentDetailsUtil.getPageListInfo(wcmUsePojoModel, pageManager, resourceResolver, pageList, detailsComponentName, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(WCMUsePojo) B2 -> B3 could not read required objects: {}, error: {}", (Object)wcmUsePojoModel, (Object)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(PageContext pageContext, PageManager pageManager, ResourceResolver resourceResolver, Iterator<Page> pageList, String[] detailsComponentName, String[] pageRoots) {
        try {
            return ComponentDetailsUtil.getPageListInfo(pageContext, pageManager, resourceResolver, pageList, detailsComponentName, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(PageContext) B2 -> B3 could not read required objects", (Throwable)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(WCMUsePojo wcmUsePojoModel, PageManager pageManager, ResourceResolver resourceResolver, Iterator<Page> pageList, String[] detailsComponentName, String[] pageRoots, Integer collectChildrenFromRoot, Boolean ignoreHidden) {
        try {
            return ComponentDetailsUtil.getPageListInfo(ComponentsUtil.getContextObjects(wcmUsePojoModel), pageManager, resourceResolver, pageList, detailsComponentName, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(WCMUsePojo) B3 could not read required objects: {},error={},pageManager={},resourceResolver={},pageList={},detailsComponentName={},pageRoots={}", new Object[]{wcmUsePojoModel, ex, pageManager, resourceResolver, pageList, detailsComponentName, pageRoots});
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(PageContext pageContext, PageManager pageManager, ResourceResolver resourceResolver, Iterator<Page> pageList, String[] detailsComponentName, String[] pageRoots, Integer collectChildrenFromRoot, Boolean ignoreHidden) {
        try {
            return ComponentDetailsUtil.getPageListInfo(ComponentsUtil.getContextObjects(pageContext), pageManager, resourceResolver, pageList, detailsComponentName, pageRoots, null, (Boolean)false);
        }
        catch (Exception ex) {
            LOGGER.error("getPageListInfo(PageContext) B3 could not read required objects", (Throwable)ex);
            return new ArrayList<ComponentProperties>();
        }
    }

    public static List<ComponentProperties> getPageListInfo(Map<String, Object> pageContext, PageManager pageManager, ResourceResolver resourceResolver, Iterator<Page> pageList, String[] detailsComponentName, String[] pageRoots, Integer collectChildrenFromRoot, Boolean ignoreHidden) {
        ArrayList<ComponentProperties> pages = new ArrayList<ComponentProperties>();
        if (pageList != null) {
            while (pageList.hasNext()) {
                Page child = pageList.next();
                if (ignoreHidden.booleanValue() && child.isHideInNav()) continue;
                pages.add(ComponentDetailsUtil.getPageInfo(pageContext, child, resourceResolver, detailsComponentName, pageRoots, collectChildrenFromRoot));
            }
        }
        return pages;
    }

    public static boolean checkSelected(Page page, Page currentPage, ResourceResolver resourceResolver) {
        return currentPage.equals(page) || currentPage.getPath().startsWith(page.getPath() + "/") || ComponentDetailsUtil.currentPageIsRedirectTarget(page, currentPage, resourceResolver);
    }

    public static boolean currentPageIsRedirectTarget(Page page, Page currentPage, ResourceResolver resourceResolver) {
        Page redirectPage;
        PageManager pageManager;
        ValueMap valueMap;
        String redirectTarget;
        boolean currentPageIsRedirectTarget = false;
        Resource contentResource = page.getContentResource();
        if (contentResource != null && StringUtils.isNotBlank((CharSequence)(redirectTarget = (String)(valueMap = contentResource.getValueMap()).get("cq:redirectTarget", String.class))) && (pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class)) != null && currentPage.equals(redirectPage = pageManager.getPage(redirectTarget))) {
            currentPageIsRedirectTarget = true;
        }
        return currentPageIsRedirectTarget;
    }

    public static ComponentProperties getPageInfo(Map<String, Object> pageContext, Page page, ResourceResolver resourceResolver, String[] componentNames, String[] pageRoots, Integer collectChildrenFromRoot) {
        return ComponentDetailsUtil.getPageInfo(pageContext, page, resourceResolver, componentNames, pageRoots, collectChildrenFromRoot, 1);
    }

    public static ComponentProperties getPageInfo(Map<String, Object> pageContext, Page page, ResourceResolver resourceResolver, String[] componentNames, String[] pageRoots, Integer collectChildrenFromRoot, Integer depth) {
        ComponentProperties componentProperties = ComponentsUtil.getNewComponentProperties(pageContext);
        try {
            if (page != null) {
                Page selectedPage;
                Resource detailsNodeResource;
                String detailsNodePath = CommonUtil.findComponentInPage(page, componentNames, pageRoots);
                if (StringUtils.isNotEmpty((CharSequence)detailsNodePath) && !ResourceUtil.isNonExistingResource((Resource)(detailsNodeResource = resourceResolver.resolve(detailsNodePath)))) {
                    Object source = pageContext.get("object");
                    String sourcetype = pageContext.get("objecttype").toString();
                    HashMap<String, Object> pageContextMap = new HashMap();
                    switch (sourcetype) {
                        case "pagecontext": {
                            pageContextMap = ComponentsUtil.getContextObjects((PageContext)source);
                            break;
                        }
                        case "wcmusepojo": {
                            pageContextMap = ComponentsUtil.getContextObjects((WCMUsePojo)source);
                            break;
                        }
                        case "slingmodel": {
                            pageContextMap = ((GenericModel)source).getPageContextMap();
                            break;
                        }
                        default: {
                            LOGGER.error("getPageInfo: invalid pageContext", pageContext);
                            return componentProperties;
                        }
                    }
                    Object[][] componentFields = new Object[][]{{"cq:tags", new String[0]}, {"pageTitle", CommonUtil.getPageTitle(page, detailsNodeResource)}, {"pageNavTitle", CommonUtil.getPageNavTitle(page)}};
                    componentProperties = ComponentsUtil.getComponentProperties(pageContextMap, (Object)detailsNodeResource, (Boolean)false, (Object[][][])new Object[][][]{componentFields, ComponentsUtil.DEFAULT_FIELDS_DETAILS_OPTIONS});
                    componentProperties.put("detailsPath", detailsNodeResource.getPath());
                    componentProperties.putAll(ImagesUtil.getAssetInfo(resourceResolver, ImagesUtil.getResourceImagePath(detailsNodeResource, "secondaryImage"), "pageSecondaryImage"));
                    componentProperties.putAll(ImagesUtil.getAssetInfo(resourceResolver, ImagesUtil.getResourceImagePath(detailsNodeResource, "bgimage"), "pageBackgroundImage"));
                }
                componentProperties.put("title", page.getTitle());
                componentProperties.put("pageTags", TagUtil.getPageTags(page));
                componentProperties.put("description", page.getDescription());
                componentProperties.put("hideInNav", page.isHideInNav());
                componentProperties.put("pageNavTitle", CommonUtil.getPageNavTitle(page));
                componentProperties.put("name", page.getName());
                componentProperties.put("href", CommonUtil.getPageUrl(page));
                componentProperties.put("authHref", page.getPath().concat(".html"));
                componentProperties.put("path", page.getPath());
                componentProperties.put("depth", depth);
                componentProperties.put("vanityPath", StringUtils.defaultIfEmpty((CharSequence)page.getVanityUrl(), (CharSequence)""));
                componentProperties.putAll(ImagesUtil.getAssetInfo(resourceResolver, ImagesUtil.getPageImgReferencePath(page), "pageImage"));
                String[] tags = (String[])componentProperties.get("cq:tags", new String[0]);
                componentProperties.put("category", TagUtil.getTagsAsValuesAsAdmin((SlingScriptHelper)pageContext.get("sling"), ",", tags));
                String contentNode = CommonUtil.getComponentNodePath(page, pageRoots);
                if (StringUtils.isNotEmpty((CharSequence)contentNode)) {
                    componentProperties.put("pageContent", contentNode);
                }
                if ((selectedPage = (Page)pageContext.get("currentPage")) != null) {
                    componentProperties.put("current", ComponentDetailsUtil.checkSelected(page, selectedPage, (ResourceResolver)pageContext.get("resourceResolver")));
                }
                if (collectChildrenFromRoot != null && collectChildrenFromRoot > 0) {
                    Iterator children;
                    ArrayList<ComponentProperties> childrenList = new ArrayList<ComponentProperties>();
                    SlingHttpServletRequest req = (SlingHttpServletRequest)pageContext.get("slingRequest");
                    if (req != null && (children = page.listChildren((Filter)new PageFilter((ServletRequest)req))) != null) {
                        componentProperties.put("hasChildren", children.hasNext());
                        while (children.hasNext()) {
                            Page nextchild = (Page)children.next();
                            childrenList.add(ComponentDetailsUtil.getPageInfo(pageContext, nextchild, resourceResolver, componentNames, pageRoots, collectChildrenFromRoot - 1, depth + 1));
                        }
                        componentProperties.put("children", childrenList);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("getPageInfo: error={}", (Throwable)ex);
        }
        return componentProperties;
    }

    public static ComponentProperties processBadgeRequestConfig(ComponentProperties componentProperties, ResourceResolver resourceResolver, HttpServletRequest request) {
        ComponentProperties badgeConfig = (ComponentProperties)((Object)request.getAttribute("badgeRequestAttributes"));
        if (badgeConfig == null || resourceResolver == null || request == null || componentProperties == null) {
            badgeConfig = new ComponentProperties();
            badgeConfig.put("badgeConfigSet", false);
            return badgeConfig;
        }
        try {
            Rendition bestRendition;
            Asset badgeThumbnailAsset;
            Resource badgeThumbnailResource;
            badgeConfig.put("badgeConfigSet", true);
            int thumbnailWidth = (Integer)componentProperties.get("badgeThumbnailWidth", 319);
            String badgeThumbnailType = (String)componentProperties.get("badgeThumbnailType", "rendition");
            String pageImage = (String)componentProperties.get("pageImage", "");
            String pageImage_Thumbnail = (String)componentProperties.get("pageImageThumbnail", "");
            String pageSecondaryImage = (String)componentProperties.get("pageSecondaryImage", "");
            String pageSecondaryImage_Thumbnail = (String)componentProperties.get("pageSecondaryImageThumbnail", "");
            String pageThumbnailImage = (String)componentProperties.get("pageThumbnailImage", "");
            String pageThumbnailImage_Thumbnail = (String)componentProperties.get("pageThumbnailImageThumbnail", "");
            String badgeThumbnail = (String)badgeConfig.get("badgeThumbnail", "");
            String badgeThumbnail_Thumbnail = "";
            int badgeThumbnailWidth = (Integer)badgeConfig.get("badgeThumbnailWidth", thumbnailWidth);
            badgeConfig.put("pageThumbnail", "/etc.clientlibs/settings/wcm/designs/aemdesign/clientlibs-theme/resources/blank.png");
            if (StringUtils.isNotEmpty((CharSequence)badgeThumbnail) && !ResourceUtil.isNonExistingResource((Resource)(badgeThumbnailResource = resourceResolver.resolve(badgeThumbnail))) && (badgeThumbnailAsset = (Asset)badgeThumbnailResource.adaptTo(Asset.class)) != null && (bestRendition = ImagesUtil.getBestFitRendition(badgeThumbnailWidth, badgeThumbnailAsset)) != null) {
                badgeThumbnail_Thumbnail = bestRendition.getPath();
            }
            if (StringUtils.isNotEmpty((CharSequence)pageImage_Thumbnail)) {
                badgeConfig.put("pageThumbnail", ImagesUtil.getBestFitRendition(pageImage, badgeThumbnailWidth, resourceResolver));
            }
            if (StringUtils.isNotEmpty((CharSequence)pageSecondaryImage_Thumbnail)) {
                badgeConfig.put("pageThumbnail", ImagesUtil.getBestFitRendition(pageSecondaryImage, badgeThumbnailWidth, resourceResolver));
            }
            if (StringUtils.isNotEmpty((CharSequence)pageThumbnailImage_Thumbnail)) {
                badgeConfig.put("pageThumbnail", ImagesUtil.getBestFitRendition(pageThumbnailImage, badgeThumbnailWidth, resourceResolver));
            }
            if (StringUtils.isNotEmpty((CharSequence)badgeThumbnail_Thumbnail)) {
                badgeConfig.put("pageThumbnail", ImagesUtil.getBestFitRendition(badgeThumbnail, badgeThumbnailWidth, resourceResolver));
            }
        }
        catch (Exception ex) {
            LOGGER.error("processBadgeRequestConfig: could not process {}", (Throwable)ex);
        }
        return badgeConfig;
    }
}

