/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.components.Toolbar;
import com.day.cq.wcm.foundation.Paragraph;
import com.day.cq.wcm.foundation.ParagraphSystem;
import com.day.cq.wcm.foundation.Placeholder;
import design.aem.components.ComponentProperties;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.jsp.JspWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class ParagraphUtil {
    public static final String COLUMN_CLASS = "col-sm";
    public static final String ROW_CLASS = "row";
    public static final String COLUMNS_CLASS = "parsys_column";

    public static void openRow(Object parSys, Paragraph par, JspWriter out, ComponentProperties componentProperties, String rowClass) throws IOException {
        ParagraphUtil.openRow(par.getNumCols(), out, componentProperties, rowClass);
    }

    public static void openRow(Integer numCols, JspWriter out, ComponentProperties componentProperties, String rowClass) throws IOException {
        String numColsCSS = MessageFormat.format("colctrl-{0}c", numCols);
        if (componentProperties != null) {
            componentProperties.attr.add("class", numColsCSS);
            String componentAttributes = componentProperties.attr.build().replaceAll("&#x20;", " ");
            out.write(MessageFormat.format("<div{0}>", componentAttributes));
        } else {
            out.write(MessageFormat.format("<div class=\"{}\">", numColsCSS));
        }
        out.write(MessageFormat.format("<div class=\"{0} {1} {2}\">", COLUMNS_CLASS, ROW_CLASS, rowClass));
    }

    public static void closeRow(Paragraph par, JspWriter out, boolean clearFix) throws IOException {
        ParagraphUtil.closeRow(out, clearFix);
    }

    public static void closeRow(JspWriter out, boolean clearFix) throws IOException {
        out.write("</div>");
        out.write("</div>");
        if (clearFix) {
            out.write("<div style=\"clear:both\"></div>");
        }
    }

    public static void openCol(Object parSys, Paragraph par, JspWriter out, ComponentProperties componentProperties, String columnClassStyle) throws IOException {
        ParagraphUtil.openCol(Arrays.asList(par.getBaseCssClass().split(",")), par.getColNr(), par.getCssClass(), out, componentProperties, columnClassStyle);
    }

    public static void openCol(List<String> columnsFormat, Integer colNumber, String columnClass, JspWriter out, ComponentProperties componentProperties, String columnClassStyle) throws IOException {
        if (columnsFormat.size() >= 1 && columnsFormat.get(0).contains(",")) {
            StringBuilder columnClassBuilder = new StringBuilder();
            for (int i = 0; i < columnsFormat.size(); ++i) {
                String spacer = i == columnsFormat.size() - 1 ? "" : " ";
                columnClassBuilder.append(columnsFormat.get(i).split(",")[0]);
                columnClassBuilder.append(columnsFormat.get(i).split(",")[colNumber + 1]);
                columnClassBuilder.append(spacer);
            }
            out.write(MessageFormat.format("<div class=\"{0} {1} {2} {3}\">", COLUMNS_CLASS, COLUMN_CLASS, columnClassBuilder.toString(), columnClassStyle));
        } else {
            out.write(MessageFormat.format("<div class=\"{0} {1} {2} {3}\">", COLUMNS_CLASS, COLUMN_CLASS, columnClass, columnClassStyle));
        }
    }

    public static void openCol(Integer colNumber, JspWriter out, ComponentProperties componentProperties, String columnClassStyle) throws IOException {
        List<String> columnsFormat = new ArrayList<String>();
        String defaultFormat = "1;colctrl-1c";
        String columnClass = "colctrl";
        if (componentProperties != null) {
            columnsFormat = Arrays.asList(((String)componentProperties.get("layout", defaultFormat)).split(";"));
            columnClass = (String)componentProperties.get("class", columnClass);
        }
        ParagraphUtil.openCol(columnsFormat, colNumber, columnClass, out, componentProperties, columnClassStyle);
    }

    public static void closeCol(Paragraph par, JspWriter out) throws IOException {
        out.write("</div>");
    }

    public static Paragraph getLastItemInColumn(Object parSys, Paragraph par) {
        Paragraph lastItemPar = null;
        int parPosition = ParagraphUtil.getListPosition(parSys, par);
        int listSize = ParagraphUtil.getListSize(parSys);
        int lookAheadIndex = -1;
        for (int i = parPosition + 1; i < listSize; ++i) {
            Resource rpar;
            lookAheadIndex = i;
            Paragraph lpar = ParagraphUtil.getListPar(parSys, i);
            if (lpar != null && (rpar = lpar.getResource()) != null && rpar.getResourceType().endsWith("/colctrl")) break;
        }
        if (lookAheadIndex >= parPosition + 2) {
            int lastColumnItemIndex = lookAheadIndex - 1;
            lastItemPar = ParagraphUtil.getListPar(parSys, lastColumnItemIndex);
        }
        return lastItemPar;
    }

    public static int getListPosition(Object parSys, Paragraph par) {
        if (parSys instanceof ParagraphSystem) {
            return ((ParagraphSystem)parSys).paragraphs().indexOf(par);
        }
        if (parSys instanceof LinkedList) {
            return ((LinkedList)parSys).indexOf(par);
        }
        return -1;
    }

    public static int getListSize(Object parSys) {
        if (parSys instanceof ParagraphSystem) {
            return ((ParagraphSystem)parSys).paragraphs().size();
        }
        if (parSys instanceof LinkedList) {
            return ((LinkedList)parSys).size();
        }
        return -1;
    }

    public static Paragraph getListPar(Object parSys, int index) {
        if (parSys instanceof ParagraphSystem) {
            return (Paragraph)((ParagraphSystem)parSys).paragraphs().get(index);
        }
        if (parSys instanceof LinkedList) {
            return (Paragraph)((LinkedList)parSys).get(index);
        }
        return null;
    }

    public static void includeEditRowStart(Resource resource, SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse, EditContext editContext, JspWriter out, Map<String, Object> componentStyle, String title) throws IOException, ServletException {
        WCMMode currentMode = WCMMode.fromRequest((ServletRequest)slingRequest);
        if (editContext != null && (currentMode.equals((Object)WCMMode.EDIT) || currentMode.equals((Object)WCMMode.PREVIEW) && ParagraphUtil.uiMode(slingRequest).equalsIgnoreCase("TOUCH"))) {
            out.write("<div class=\"section\">");
            out.flush();
            editContext.setAttribute("currentResource", (Object)resource);
            out.write(Placeholder.getDefaultPlaceholder((ServletRequest)slingRequest, (String)title, (String)"", (String[])new String[]{"cq-marker-start"}));
            editContext.getEditConfig().getToolbar().add(0, (Toolbar.Item)new Toolbar.Separator());
            editContext.getEditConfig().getToolbar().add(0, (Toolbar.Item)new Toolbar.Label(title));
            editContext.getEditConfig().setOrderable(Boolean.valueOf(false));
            out.flush();
            editContext.includeEpilog(slingRequest, slingResponse, WCMMode.EDIT);
            out.write("</div>");
        }
    }

    public static void includeEditRowEnd(Resource resource, SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse, EditContext editContext, JspWriter out, Map<String, Object> componentStyle, String title) throws IOException, ServletException {
        WCMMode currentMode = WCMMode.fromRequest((ServletRequest)slingRequest);
        if (editContext != null && (currentMode.equals((Object)WCMMode.EDIT) || currentMode.equals((Object)WCMMode.PREVIEW) && ParagraphUtil.uiMode(slingRequest).equalsIgnoreCase("TOUCH"))) {
            out.write("<div class=\"section\">");
            out.flush();
            editContext.setAttribute("currentResource", (Object)resource);
            out.write(Placeholder.getDefaultPlaceholder((ServletRequest)slingRequest, (String)title, (String)"", (String[])new String[]{"cq-marker-end"}));
            editContext.getEditConfig().getToolbar().clear();
            editContext.getEditConfig().getToolbar().add((Toolbar.Item)new Toolbar.Label(title));
            editContext.getEditConfig().setOrderable(Boolean.valueOf(false));
            editContext.setContentPath(resource.getPath() + "_fake");
            out.flush();
            editContext.includeEpilog(slingRequest, slingResponse, WCMMode.fromRequest((ServletRequest)slingRequest));
            out.write("</div>");
        }
    }

    public static void includeEditContext(Resource resource, SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse, EditContext editContext, JspWriter out, Map<String, Object> componentStyle, String title) throws IOException, ServletException {
        out.flush();
        editContext.includeEpilog(slingRequest, slingResponse, WCMMode.fromRequest((ServletRequest)slingRequest));
    }

    public static Integer getChildCount(Iterator<Resource> itr) {
        Integer count = 0;
        while (itr.hasNext()) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            itr.next();
        }
        return count;
    }

    public static Resource getLastElement(Iterator<Resource> itr) {
        Resource lastResource = null;
        if (itr != null && itr.hasNext()) {
            lastResource = itr.next();
            while (itr.hasNext()) {
                lastResource = itr.next();
            }
        }
        return lastResource;
    }

    public static Resource getFirstElement(Iterator<Resource> itr) {
        Resource lastResource = null;
        if (itr != null && itr.hasNext()) {
            lastResource = itr.next();
        }
        return lastResource;
    }

    public static void openCol(JspWriter out, Map componentStyle, Integer currColNumber) throws IOException {
        String layout = (String)componentStyle.get("layout");
        String[] width = layout.split(",");
        if (width.length > 1) {
            out.write("<div class='col-sm " + width[0] + width[currColNumber] + "'>");
        } else {
            out.write("<div class='col-sm " + width[0] + "'>");
        }
    }

    public static Paragraph.Type currentControlType(Resource resource) {
        ValueMap resProp = (ValueMap)resource.adaptTo(ValueMap.class);
        if (resProp != null) {
            return Paragraph.Type.valueOf((String)((String)resProp.get("controlType", (Object)"start")).toUpperCase());
        }
        return Paragraph.Type.NORMAL;
    }

    public static String uiMode(SlingHttpServletRequest slingRequest) {
        Cookie cookie = slingRequest.getCookie("cq-authoring-mode");
        if (cookie != null) {
            return cookie.getValue();
        }
        return "";
    }
}

