/*
 * Decompiled with CFR 0.152.
 */
package design.aem.utils.components;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TenantUtil {
    private static final List<Pattern> tenantPathPatterns = Arrays.asList(Pattern.compile("(?:cq:tags/)([^/]+)"), Pattern.compile("(?:experience-fragments/)([^/]+)"), Pattern.compile("^/content/([^/]+)"), Pattern.compile("^/conf/([^/]+)/*"));

    public static String resolveTenantIdFromPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        for (Pattern pathPattern : tenantPathPatterns) {
            Matcher matcher = pathPattern.matcher(path);
            if (!matcher.find() || matcher.groupCount() < 1) continue;
            String tenantId = matcher.group(1);
            return tenantId;
        }
        return null;
    }
}

