// Generated by delombok at Wed Aug 30 12:58:32 UTC 2023
/*
 * Copyright 2023 Adrian Herscu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dev.aherscu.qa.jgiven.reporter;

import static org.apache.commons.io.FileUtils.*;
import static org.apache.commons.lang3.StringUtils.*;

import java.io.*;
import java.util.*;

import org.apache.commons.io.filefilter.*;
import org.testng.*;
import org.testng.xml.*;

import com.samskivert.mustache.*;
import com.tngtech.jgiven.impl.*;
import com.tngtech.jgiven.report.model.*;

import dev.aherscu.qa.testing.utils.*;
import lombok.*;
import lombok.extern.slf4j.*;

/**
 * Base functionality and defaults for all kinds of reporters.
 * <p>
 * Can be invoked as a TestNG Reporter, hence supports {@link IReporter} by
 * implementing its {@link #generateReport(List, List, String)} and provides a
 * no-args constructor. It also can be invoked from other workflow engine, such
 * as from a Maven plugin, which should just call {@link #generate()} -- see the
 * qa-testrail-reporter and qa-jgiven-reporter-maven-plugin sibling modules.
 * </p>
 * <p>
 * Implementors are required to specify the {@link #generate()} method.
 * </p>
 *
 * @see #with(XmlSuite) TestNG Reporter configuration
 *
 * @param <M>
 *            one of JGiven's report models: {@link CompleteReportModel}, *
 *            {@link ScenarioModel}, or {@link ReportModelFile}
 * @param <T>
 *            specific type of reporter
 */
public abstract class AbstractQaJgivenReporter<M, T extends AbstractQaJgivenReporter<?, ?>>
    implements IReporter {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log                      =
        org.slf4j.LoggerFactory.getLogger(AbstractQaJgivenReporter.class);
    public static final String            DEFAULT_REFERENCE_TAG    =
        "Reference";
    public static final String            DEFAULT_SCREENSHOT_SCALE = "0.2";
    public static final String            DEFAULT_DATE_PATTERN     =
        "yyyy-MMM-dd HH:mm O";
    protected final File                  sourceDirectory;
    // FIXME Warning:(72, 40) 'Optional.get()' without 'isPresent()' check
    protected final File                  outputDirectory;
    protected final boolean               debug;
    protected final String                screenshotScale;
    protected final String                datePattern;
    protected final boolean               pdf;
    protected final String                referenceTag;
    protected final String                templateResource;

    // see
    // https://stackoverflow.com/questions/61633821/using-lombok-superbuilder-annotation-with-tobuilder-on-an-abstract-class
    public abstract AbstractQaJgivenReporterBuilder<M, T, ?, ?> toBuilder();

    protected Mustache.Compiler compiler() {
        return Mustache.compiler();
    }

    protected QaJGivenReportModel<M> reportModel(final File targetReportFile) {
        return QaJGivenReportModel.<M> builder()
            .targetReportFile(targetReportFile).build();
    }

    /**
     * @param xmlSuites
     *            The list of {@code XmlSuite}
     * @param suites
     *            The list of {@code ISuite}
     * @param outputDirectory
     *            The output directory is ignored, since it is specified by
     *            JGiven reporter infrastructure
     */
    @Override
    public void generateReport(final List<XmlSuite> xmlSuites,
        final List<ISuite> suites,
        @SuppressWarnings("hiding") final String outputDirectory) {
        xmlSuites.forEach(xmlSuite -> log.info("xml suite {}", xmlSuite));
        // ISSUE: should be empty for xml driven invocations (?)
        // if yes, then should throw an unsupported exception
        suites.forEach(suite -> log.info("suite {}", suite.getName()));
        xmlSuites.forEach(xmlSuite -> with(xmlSuite).prepare().generate());
    }

    /**
     * Builds a new reporter configured per following TestNG XML suite
     * parameters:
     * <dl>
     * <dt>referenceTag</dt>
     * <dd>the reference tag identifier, or {@link #DEFAULT_REFERENCE_TAG}</dd>
     * <dt>screenshotScale</dt>
     * <dd>the screenshot scale to apply when embedding files into reports, or
     * {@link #DEFAULT_SCREENSHOT_SCALE}</dd>
     * <dt>datePattern</dt>
     * <dd>the date pattern to use for presenting dates, or
     * {@link #DEFAULT_DATE_PATTERN}</dd>
     * <dt>templateResourceXXX</dt>
     * <dd>the template resource file name to apply; the {@code XXX} is the
     * concrete reporter implementation name (class)</dd>
     * </dl>
     *
     * @param xmlSuite
     *            TestNG XML suite
     * @return reporter configured
     */
    protected AbstractQaJgivenReporter<M, T> with(final XmlSuite xmlSuite) {
        return
        // NOTE see
        // https://stackoverflow.com/questions/56761054/lombok-wither-with-inheritance-super-sub-classes
        this.toBuilder()
            .referenceTag(defaultIfBlank(xmlSuite.getParameter("referenceTag"),
                referenceTag))
            .screenshotScale(defaultIfBlank(
                xmlSuite.getParameter("screenshotScale"), screenshotScale))
            .datePattern(defaultIfBlank(xmlSuite.getParameter("datePattern"),
                datePattern))
            .templateResource(
                templateResourceParamFrom(xmlSuite, templateResource))
            .build();
    }

    public AbstractQaJgivenReporter<M, T> prepare() {
        try {
            log.info("configuration {}", this);
            forceMkdir(outputDirectory);
            return this;
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
    }

    protected String templateResourceParamFrom(final XmlSuite xmlSuite,
        final String defaultTemplateResource) {
        return defaultIfBlank(
            xmlSuite.getParameter(
                "templateResource" + this.getClass().getSimpleName()),
            defaultTemplateResource);
    }

    public abstract void generate();

    protected File reportFile(final File reportModelFile,
        final String extension) {
        return new File(outputDirectory, reportModelFile.getName() + extension);
    }

    protected Collection<File> listJGivenReports() {
        return listFiles(sourceDirectory, new SuffixFileFilter(".json"), null);
    }

    protected Template template() {
        return TemplateUtils.using(compiler()).loadFrom(templateResource);
    }

    @java.lang.SuppressWarnings("all")
    private static <M, T extends AbstractQaJgivenReporter<?, ?>> File $default$sourceDirectory() {
        return Config.config().getReportDir().get();
    }

    @java.lang.SuppressWarnings("all")
    private static <M, T extends AbstractQaJgivenReporter<?, ?>> File $default$outputDirectory() {
        return new File(Config.config().getReportDir().get(), "qa-html");
    }

    @java.lang.SuppressWarnings("all")
    private static <M, T extends AbstractQaJgivenReporter<?, ?>> boolean $default$debug() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    private static <M, T extends AbstractQaJgivenReporter<?, ?>> String $default$screenshotScale() {
        return DEFAULT_SCREENSHOT_SCALE;
    }

    @java.lang.SuppressWarnings("all")
    private static <M, T extends AbstractQaJgivenReporter<?, ?>> String $default$datePattern() {
        return DEFAULT_DATE_PATTERN;
    }

    @java.lang.SuppressWarnings("all")
    private static <M, T extends AbstractQaJgivenReporter<?, ?>> boolean $default$pdf() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    private static <M, T extends AbstractQaJgivenReporter<?, ?>> String $default$referenceTag() {
        return DEFAULT_REFERENCE_TAG;
    }

    @java.lang.SuppressWarnings("all")
    public static abstract class AbstractQaJgivenReporterBuilder<M, T extends AbstractQaJgivenReporter<?, ?>, C extends AbstractQaJgivenReporter<M, T>, B extends AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder<M, T, C, B>> {
        @java.lang.SuppressWarnings("all")
        private boolean sourceDirectory$set;
        @java.lang.SuppressWarnings("all")
        private File    sourceDirectory$value;
        @java.lang.SuppressWarnings("all")
        private boolean outputDirectory$set;
        @java.lang.SuppressWarnings("all")
        private File    outputDirectory$value;
        @java.lang.SuppressWarnings("all")
        private boolean debug$set;
        @java.lang.SuppressWarnings("all")
        private boolean debug$value;
        @java.lang.SuppressWarnings("all")
        private boolean screenshotScale$set;
        @java.lang.SuppressWarnings("all")
        private String  screenshotScale$value;
        @java.lang.SuppressWarnings("all")
        private boolean datePattern$set;
        @java.lang.SuppressWarnings("all")
        private String  datePattern$value;
        @java.lang.SuppressWarnings("all")
        private boolean pdf$set;
        @java.lang.SuppressWarnings("all")
        private boolean pdf$value;
        @java.lang.SuppressWarnings("all")
        private boolean referenceTag$set;
        @java.lang.SuppressWarnings("all")
        private String  referenceTag$value;
        @java.lang.SuppressWarnings("all")
        private String  templateResource;

        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder
                .$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static <M, T extends AbstractQaJgivenReporter<?, ?>> void $fillValuesFromInstanceIntoBuilder(
            final AbstractQaJgivenReporter<M, T> instance,
            final AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder<M, T, ?, ?> b) {
            b.sourceDirectory(instance.sourceDirectory);
            b.outputDirectory(instance.outputDirectory);
            b.debug(instance.debug);
            b.screenshotScale(instance.screenshotScale);
            b.datePattern(instance.datePattern);
            b.pdf(instance.pdf);
            b.referenceTag(instance.referenceTag);
            b.templateResource(instance.templateResource);
        }

        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        public abstract C build();

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B sourceDirectory(final File sourceDirectory) {
            this.sourceDirectory$value = sourceDirectory;
            sourceDirectory$set = true;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B outputDirectory(final File outputDirectory) {
            this.outputDirectory$value = outputDirectory;
            outputDirectory$set = true;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B debug(final boolean debug) {
            this.debug$value = debug;
            debug$set = true;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B screenshotScale(final String screenshotScale) {
            this.screenshotScale$value = screenshotScale;
            screenshotScale$set = true;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B datePattern(final String datePattern) {
            this.datePattern$value = datePattern;
            datePattern$set = true;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B pdf(final boolean pdf) {
            this.pdf$value = pdf;
            pdf$set = true;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B referenceTag(final String referenceTag) {
            this.referenceTag$value = referenceTag;
            referenceTag$set = true;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B templateResource(final String templateResource) {
            this.templateResource = templateResource;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder(sourceDirectory$value="
                + this.sourceDirectory$value + ", outputDirectory$value="
                + this.outputDirectory$value + ", debug$value="
                + this.debug$value + ", screenshotScale$value="
                + this.screenshotScale$value + ", datePattern$value="
                + this.datePattern$value + ", pdf$value=" + this.pdf$value
                + ", referenceTag$value=" + this.referenceTag$value
                + ", templateResource=" + this.templateResource + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    protected AbstractQaJgivenReporter(
        final AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder<M, T, ?, ?> b) {
        if (b.sourceDirectory$set)
            this.sourceDirectory = b.sourceDirectory$value;
        else
            this.sourceDirectory =
                AbstractQaJgivenReporter.<M, T> $default$sourceDirectory();
        if (b.outputDirectory$set)
            this.outputDirectory = b.outputDirectory$value;
        else
            this.outputDirectory =
                AbstractQaJgivenReporter.<M, T> $default$outputDirectory();
        if (b.debug$set)
            this.debug = b.debug$value;
        else
            this.debug = AbstractQaJgivenReporter.<M, T> $default$debug();
        if (b.screenshotScale$set)
            this.screenshotScale = b.screenshotScale$value;
        else
            this.screenshotScale =
                AbstractQaJgivenReporter.<M, T> $default$screenshotScale();
        if (b.datePattern$set)
            this.datePattern = b.datePattern$value;
        else
            this.datePattern =
                AbstractQaJgivenReporter.<M, T> $default$datePattern();
        if (b.pdf$set)
            this.pdf = b.pdf$value;
        else
            this.pdf = AbstractQaJgivenReporter.<M, T> $default$pdf();
        if (b.referenceTag$set)
            this.referenceTag = b.referenceTag$value;
        else
            this.referenceTag =
                AbstractQaJgivenReporter.<M, T> $default$referenceTag();
        this.templateResource = b.templateResource;
    }

    @java.lang.SuppressWarnings("all")
    public AbstractQaJgivenReporter() {
        this.sourceDirectory = null;
        this.outputDirectory = null;
        this.debug = false;
        this.screenshotScale = null;
        this.datePattern = null;
        this.pdf = false;
        this.referenceTag = null;
        this.templateResource = null;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "AbstractQaJgivenReporter(sourceDirectory="
            + this.sourceDirectory + ", outputDirectory=" + this.outputDirectory
            + ", debug=" + this.debug + ", screenshotScale="
            + this.screenshotScale + ", datePattern=" + this.datePattern
            + ", pdf=" + this.pdf + ", referenceTag=" + this.referenceTag
            + ", templateResource=" + this.templateResource + ")";
    }
}
