// Generated by delombok at Wed Aug 30 12:58:32 UTC 2023
/*
 * Copyright 2023 Adrian Herscu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dev.aherscu.qa.jgiven.reporter;

import static dev.aherscu.qa.testing.utils.FileUtilsExtensions.*;
import static org.apache.commons.io.FilenameUtils.*;
import static org.xhtmlrenderer.simple.PDFRenderer.*;

import org.testng.xml.*;

import com.tngtech.jgiven.report.json.*;
import com.tngtech.jgiven.report.model.*;

import lombok.*;
import lombok.extern.slf4j.*;

/**
 * Per test class reporter.
 */
public class QaJGivenPerClassReporter extends
    AbstractQaJgivenReporter<ReportModelFile, QaJGivenPerClassReporter> {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log                       =
        org.slf4j.LoggerFactory.getLogger(QaJGivenPerClassReporter.class);
    public static final String            DEFAULT_TEMPLATE_RESOURCE =
        "/qa-jgiven-perclass-reporter.html";

    /**
     * Builds a new reporter configured with additional TestNG XML suite
     * parameters. Currently, only {@code templateResource} is recognized.
     *
     * @param xmlSuite
     *            TestNG XML suite
     * @return reporter configured
     */
    @Override
    protected QaJGivenPerClassReporter with(final XmlSuite xmlSuite) {
        return ((QaJGivenPerClassReporter) super.with(xmlSuite)).toBuilder()
            .templateResource(
                templateResourceParamFrom(xmlSuite, DEFAULT_TEMPLATE_RESOURCE))
            .build();
    }

    /**
     * Generates a report for each test class. It is assumed that JGiven
     * generates a JSON file for each test class.
     */
    @Override
    public void generate() {
        try {
            for (final java.io.File reportModelFile : listJGivenReports()) {
                log.debug("reading " + reportModelFile);
                // TODO make it read .mustache files and drop the extension here
                final java.io.File targetReportFile = reportFile(
                    reportModelFile,
                    EXTENSION_SEPARATOR_STR + getExtension(templateResource));
                try (java.io.Writer reportWriter =
                    fileWriter(targetReportFile)) {
                    template()
                        .execute(
                            reportModel(targetReportFile).toBuilder()
                                .jgivenReport(new ReportModelFileReader()
                                    .apply(reportModelFile))
                                .screenshotScale(screenshotScale)
                                .datePattern(datePattern).build(),
                            reportWriter);
                }
                // FIXME should work only with html reports
                if (pdf) {
                    renderToPDF(reportFile(reportModelFile, ".html"),
                        reportFile(reportModelFile, ".pdf").getAbsolutePath());
                }
            }
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
    }

    @java.lang.SuppressWarnings("all")
    public static abstract class QaJGivenPerClassReporterBuilder<C extends QaJGivenPerClassReporter, B extends QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder<C, B>>
        extends
        AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder<ReportModelFile, QaJGivenPerClassReporter, C, B> {
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder
                .$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(
            final QaJGivenPerClassReporter instance,
            final QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder<?, ?> b) {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder(super="
                + super.toString() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    private static final class QaJGivenPerClassReporterBuilderImpl extends
        QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder<QaJGivenPerClassReporter, QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private QaJGivenPerClassReporterBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public QaJGivenPerClassReporter build() {
            return new QaJGivenPerClassReporter(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected QaJGivenPerClassReporter(
        final QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder<?, ?> b) {
        super(b);
    }

    @java.lang.SuppressWarnings("all")
    public static QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder<?, ?> builder() {
        return new QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilder<?, ?> toBuilder() {
        return new QaJGivenPerClassReporter.QaJGivenPerClassReporterBuilderImpl()
            .$fillValuesFrom(this);
    }

    @java.lang.SuppressWarnings("all")
    public QaJGivenPerClassReporter() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "QaJGivenPerClassReporter(super=" + super.toString() + ")";
    }
}
