// Generated by delombok at Wed Aug 30 12:58:32 UTC 2023
/*
 * Copyright 2023 Adrian Herscu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dev.aherscu.qa.jgiven.reporter;

import static com.google.common.collect.Maps.*;
import static com.google.common.collect.Multimaps.*;
import static dev.aherscu.qa.testing.utils.FileUtilsExtensions.*;
import static dev.aherscu.qa.testing.utils.StringUtilsExtensions.*;
import static java.util.stream.Collectors.toMap;
import static org.apache.commons.io.FilenameUtils.*;

import java.io.*;
import java.text.*;
import java.util.*;

import org.jooq.lambda.*;
import org.testng.xml.*;

import com.google.common.collect.*;
import com.tngtech.jgiven.report.json.*;
import com.tngtech.jgiven.report.model.*;

import lombok.*;
import lombok.extern.slf4j.*;

/**
 * Per test method reporter.
 */
public class QaJGivenPerMethodReporter
    extends AbstractQaJgivenReporter<ScenarioModel, QaJGivenPerMethodReporter> {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log                       =
        org.slf4j.LoggerFactory.getLogger(QaJGivenPerMethodReporter.class);
    public static final String            DEFAULT_TEMPLATE_RESOURCE =
        "/qa-jgiven-permethod-reporter.html";

    public static Map<String, String> readAttributesOf(final File reportFile) {
        try {
            try (java.io.Reader attributesReader = fileReader(
                new File(reportFile.getAbsolutePath() + ".attributes"))) {
                final java.util.Properties p = new Properties();
                p.load(attributesReader);
                return fromProperties(p);
            }
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
    }

    /**
     * Builds a new reporter configured with additional TestNG XML suite
     * parameters. Currently, only {@code templateResource} is recognized.
     *
     * @param xmlSuite
     *            TestNG XML suite
     * @return reporter configured
     */
    @Override
    protected QaJGivenPerMethodReporter with(final XmlSuite xmlSuite) {
        return ((QaJGivenPerMethodReporter) super.with(xmlSuite)).toBuilder()
            .templateResource(
                templateResourceParamFrom(xmlSuite, DEFAULT_TEMPLATE_RESOURCE))
            .build();
    }

    protected void applyAttributesFor(final ScenarioModel scenarioModel,
        final File reportFile) {
        try {
            log.info("setting attributes for " + reportFile.getName());
            try (java.io.Writer attributesWriter = fileWriter(
                new File(reportFile.getAbsolutePath() + ".attributes"))) {
                final java.util.Properties p = new Properties();
                p.putAll(
                    // TODO apply the mapping here
                    // NOTE there might be multiple
                    // DeviceName/PlatformName/PlatformVersion tags
                    // NOTE here we merge them all under one key
                    scenarioModel.getTagIds().stream()
                        .map(tag -> immutableEntry(substringBefore(tag, DASH),
                            substringAfter(tag, DASH)))
                        .collect(
                            toMultimap(Map.Entry::getKey, Map.Entry::getValue,
                                MultimapBuilder.hashKeys()
                                    .arrayListValues()::build))
                        .asMap().entrySet().stream()
                        .map(e -> immutableEntry(e.getKey(),
                            String.join(COMMA, e.getValue())))
                        .collect(
                            toMap(Map.Entry::getKey, Map.Entry::getValue)));
                p.store(attributesWriter,
                    "generated by qa-jgiven-reporter-maven-plugin");
            }
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
    }

    /**
     * Generates a report for each test method (scenario in JGiven terms).
     */
    @Override
    public void generate() {
        try {
            listJGivenReports().parallelStream()
                .peek(reportModelFile -> log
                    .debug("reading " + reportModelFile.getName()))
                .flatMap(reportModelFile -> new ReportModelFileReader()
                    .apply(reportModelFile).model
                        .getScenarios().stream()
                        .filter(scenarioModel -> scenarioModel.getTagIds()
                            .stream()
                            .anyMatch(tagId -> tagId.contains(referenceTag))))
                .peek(scenarioModel -> log
                    .debug("processing " + targetNameFor(scenarioModel)))
                .forEach(Unchecked.consumer(scenarioModel -> {
                    final java.io.File targetReportFile =
                        new File(outputDirectory,
                            // TODO make it read .mustache files and drop the
                            // extension here
                            targetNameFor(scenarioModel)
                                + EXTENSION_SEPARATOR_STR
                                + getExtension(templateResource));
                    try (java.io.Writer reportWriter =
                        fileWriter(targetReportFile)) {
                        template().execute(
                            reportModel(targetReportFile).toBuilder()
                                .jgivenReport(scenarioModel)
                                .screenshotScale(screenshotScale)
                                .datePattern(datePattern).build(),
                            reportWriter);
                        applyAttributesFor(scenarioModel, targetReportFile);
                    }
                    // FIXME should work only with html reports
                    // if (pdf) {
                    // renderToPDF(
                    // reportFile(reportModelFile, ".html"),
                    // reportFile(reportModelFile, ".pdf")
                    // .getAbsolutePath());
                    // }
                    reportGenerated(scenarioModel, targetReportFile);
                }));
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
    }

    protected void reportGenerated(final ScenarioModel scenarioModel,
        final File reportFile) {
        log.debug("report generated for {} into {}",
            scenarioModel.getClassName(), reportFile.getName());
    }

    protected String targetNameFor(final ScenarioModel scenarioModel) {
        return MessageFormat.format("{0}-{1}-{2}",
            scenarioModel.getExecutionStatus(), scenarioModel.getClassName(),
            scenarioModel.getTestMethodName());
    }

    @java.lang.SuppressWarnings("all")
    public static abstract class QaJGivenPerMethodReporterBuilder<C extends QaJGivenPerMethodReporter, B extends QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder<C, B>>
        extends
        AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder<ScenarioModel, QaJGivenPerMethodReporter, C, B> {
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder
                .$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(
            final QaJGivenPerMethodReporter instance,
            final QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder<?, ?> b) {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder(super="
                + super.toString() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    private static final class QaJGivenPerMethodReporterBuilderImpl extends
        QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder<QaJGivenPerMethodReporter, QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private QaJGivenPerMethodReporterBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public QaJGivenPerMethodReporter build() {
            return new QaJGivenPerMethodReporter(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected QaJGivenPerMethodReporter(
        final QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder<?, ?> b) {
        super(b);
    }

    @java.lang.SuppressWarnings("all")
    public static QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder<?, ?> builder() {
        return new QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilder<?, ?> toBuilder() {
        return new QaJGivenPerMethodReporter.QaJGivenPerMethodReporterBuilderImpl()
            .$fillValuesFrom(this);
    }

    @java.lang.SuppressWarnings("all")
    public QaJGivenPerMethodReporter() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "QaJGivenPerMethodReporter(super=" + super.toString() + ")";
    }
}
