// Generated by delombok at Wed Aug 30 12:58:32 UTC 2023
/*
 * Copyright 2023 Adrian Herscu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dev.aherscu.qa.jgiven.reporter;

import static dev.aherscu.qa.testing.utils.StringUtilsExtensions.*;
import static java.lang.Double.*;
import static java.lang.Long.*;
import static java.text.MessageFormat.format;
import static java.time.format.DateTimeFormatter.*;

import java.io.*;
import java.nio.charset.*;
import java.time.*;
import java.util.*;
import java.util.Base64;

import org.apache.commons.codec.binary.*;
import org.apache.commons.io.output.*;

import com.samskivert.mustache.*;
import com.tngtech.jgiven.report.model.*;

import dev.aherscu.qa.testing.utils.*;
import lombok.*;
import lombok.extern.slf4j.*;

/**
 * Reporting model, comprising JGiven's report model, additional fields and
 * <a href="https://github.com/samskivert/jmustache">Mustache</a> template
 * methods. The reporting model contains all information that can be used to
 * generate a report. Template methods can be used for more advanced
 * manipulation that cannot be handled by out-of-the-box Mustache engine
 * functions.
 * <p>
 * Reporters may use it as is, or extend it with even more fields and template
 * methods per need.
 * </p>
 * <p>
 * Reports are generated by invoking the Mustache engine with a specific
 * template and a report model.
 * </p>
 *
 * @see AbstractQaJgivenReporter
 * 
 * @param <T>
 *            one of JGiven's report models: {@link CompleteReportModel},
 *            {@link ScenarioModel}, or {@link ReportModelFile}
 */
@SuppressWarnings("ClassWithTooManyFields")
@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(
    value = "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD",
    justification = "referenced from JMustache template at runtime")
public class QaJGivenReportModel<T> {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log                =
        org.slf4j.LoggerFactory.getLogger(QaJGivenReportModel.class);
    public final String                   screenshotScale;
    public final String                   testDocumentId;
    public final String                   testDocumentRev;
    public final String                   specDocumentId;
    public final String                   specDocumentRev;
    public final String                   planDocumentId;
    public final String                   planDocumentRev;
    public final String                   traceabilityDocumentId;
    public final String                   traceabilityDocumentRev;
    public final String                   productName;
    public final String                   productVersion;
    public final T                        jgivenReport;
    public final String                   datePattern;
    public final File                     targetReportFile;
    public final Mustache.Lambda          shorten            =
        (frag, out) -> out.write(
            abbreviateMiddle(prettified(frag.execute()), ELLIPSIS, 1024));
    public final Mustache.Lambda          deleteEOL          =
        (frag, out) -> out.write(
            normalizeSpace(frag.execute().replaceAll("[\\r\\n]", SPACE)));
    public final Mustache.Lambda          nanoToMillis       = (frag,
        out) -> out.write(Long.toString(parseLong(frag.execute()) / 1000000));
    public final Mustache.Lambda          asId               =
        (frag, out) -> out.write(Integer.toHexString(frag.execute().hashCode())
            .toUpperCase(Locale.ENGLISH));
    public final Mustache.Lambda          simpleName         =
        (frag, out) -> out.write(substringAfterLast(frag.execute(), DOT));
    public final Mustache.Lambda          translateIntroWord =
        this::translateIntroWord;
    public final Mustache.Lambda          scaleImage         = this::scaleImage;
    public final Mustache.Lambda          isStepFailed       =
        (frag,
            out) -> out.write(StepStatus.FAILED.equals(
                ((StepModel) frag.context()).getStatus()) ? frag.execute()
                    : EMPTY);
    public final Mustache.Lambda          isStepPassed       =
        (frag,
            out) -> out.write(StepStatus.PASSED.equals(
                ((StepModel) frag.context()).getStatus()) ? frag.execute()
                    : EMPTY);
    private final ZonedDateTime           date               =
        ZonedDateTime.now();

    public final String date() {
        return date.format(ofPattern(datePattern));
    }

    @SuppressWarnings("resource")
    public void scaleImage(final Template.Fragment frag, final Writer out) {

        // NOTE JMustache requires the output stream to be left open
        ImageUtils.Pipeline
            .from(new ByteArrayInputStream(Base64.getMimeDecoder()
                .decode(frag.execute().getBytes(StandardCharsets.UTF_8))))
            .scale(parseDouble(screenshotScale), parseDouble(screenshotScale))
            .into(new Base64OutputStream(
                new WriterOutputStream(out, StandardCharsets.UTF_8), true, -1,
                null), "png");
    }

    private void translateIntroWord(final Template.Fragment frag,
        final Writer out) {
        try {
            final java.lang.String introWord =
                frag.execute().toLowerCase(Locale.US);
            switch (introWord) {
            case "given":
                out.write("Pre-condition(s)");
                break;
            case "when":
                out.write("Operation(s)");
                break;
            case "then":
                out.write("Verification(s)");
                break;
            case "and":
            case "with":
                out.write("and");
                break;
            default:
                log.warn(
                    format("unrecognized introduction word [{0}]", introWord));
            }
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
    }

    @java.lang.SuppressWarnings("all")
    public static abstract class QaJGivenReportModelBuilder<T, C extends QaJGivenReportModel<T>, B extends QaJGivenReportModel.QaJGivenReportModelBuilder<T, C, B>> {
        @java.lang.SuppressWarnings("all")
        private String screenshotScale;
        @java.lang.SuppressWarnings("all")
        private String testDocumentId;
        @java.lang.SuppressWarnings("all")
        private String testDocumentRev;
        @java.lang.SuppressWarnings("all")
        private String specDocumentId;
        @java.lang.SuppressWarnings("all")
        private String specDocumentRev;
        @java.lang.SuppressWarnings("all")
        private String planDocumentId;
        @java.lang.SuppressWarnings("all")
        private String planDocumentRev;
        @java.lang.SuppressWarnings("all")
        private String traceabilityDocumentId;
        @java.lang.SuppressWarnings("all")
        private String traceabilityDocumentRev;
        @java.lang.SuppressWarnings("all")
        private String productName;
        @java.lang.SuppressWarnings("all")
        private String productVersion;
        @java.lang.SuppressWarnings("all")
        private T      jgivenReport;
        @java.lang.SuppressWarnings("all")
        private String datePattern;
        @java.lang.SuppressWarnings("all")
        private File   targetReportFile;

        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            QaJGivenReportModel.QaJGivenReportModelBuilder
                .$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static <T> void $fillValuesFromInstanceIntoBuilder(
            final QaJGivenReportModel<T> instance,
            final QaJGivenReportModel.QaJGivenReportModelBuilder<T, ?, ?> b) {
            b.screenshotScale(instance.screenshotScale);
            b.testDocumentId(instance.testDocumentId);
            b.testDocumentRev(instance.testDocumentRev);
            b.specDocumentId(instance.specDocumentId);
            b.specDocumentRev(instance.specDocumentRev);
            b.planDocumentId(instance.planDocumentId);
            b.planDocumentRev(instance.planDocumentRev);
            b.traceabilityDocumentId(instance.traceabilityDocumentId);
            b.traceabilityDocumentRev(instance.traceabilityDocumentRev);
            b.productName(instance.productName);
            b.productVersion(instance.productVersion);
            b.jgivenReport(instance.jgivenReport);
            b.datePattern(instance.datePattern);
            b.targetReportFile(instance.targetReportFile);
        }

        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        public abstract C build();

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B screenshotScale(final String screenshotScale) {
            this.screenshotScale = screenshotScale;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B testDocumentId(final String testDocumentId) {
            this.testDocumentId = testDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B testDocumentRev(final String testDocumentRev) {
            this.testDocumentRev = testDocumentRev;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B specDocumentId(final String specDocumentId) {
            this.specDocumentId = specDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B specDocumentRev(final String specDocumentRev) {
            this.specDocumentRev = specDocumentRev;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B planDocumentId(final String planDocumentId) {
            this.planDocumentId = planDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B planDocumentRev(final String planDocumentRev) {
            this.planDocumentRev = planDocumentRev;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B traceabilityDocumentId(final String traceabilityDocumentId) {
            this.traceabilityDocumentId = traceabilityDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B traceabilityDocumentRev(final String traceabilityDocumentRev) {
            this.traceabilityDocumentRev = traceabilityDocumentRev;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B productName(final String productName) {
            this.productName = productName;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B productVersion(final String productVersion) {
            this.productVersion = productVersion;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B jgivenReport(final T jgivenReport) {
            this.jgivenReport = jgivenReport;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B datePattern(final String datePattern) {
            this.datePattern = datePattern;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B targetReportFile(final File targetReportFile) {
            this.targetReportFile = targetReportFile;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "QaJGivenReportModel.QaJGivenReportModelBuilder(screenshotScale="
                + this.screenshotScale + ", testDocumentId="
                + this.testDocumentId + ", testDocumentRev="
                + this.testDocumentRev + ", specDocumentId="
                + this.specDocumentId + ", specDocumentRev="
                + this.specDocumentRev + ", planDocumentId="
                + this.planDocumentId + ", planDocumentRev="
                + this.planDocumentRev + ", traceabilityDocumentId="
                + this.traceabilityDocumentId + ", traceabilityDocumentRev="
                + this.traceabilityDocumentRev + ", productName="
                + this.productName + ", productVersion=" + this.productVersion
                + ", jgivenReport=" + this.jgivenReport + ", datePattern="
                + this.datePattern + ", targetReportFile="
                + this.targetReportFile + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    private static final class QaJGivenReportModelBuilderImpl<T> extends
        QaJGivenReportModel.QaJGivenReportModelBuilder<T, QaJGivenReportModel<T>, QaJGivenReportModel.QaJGivenReportModelBuilderImpl<T>> {
        @java.lang.SuppressWarnings("all")
        private QaJGivenReportModelBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected QaJGivenReportModel.QaJGivenReportModelBuilderImpl<T> self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public QaJGivenReportModel<T> build() {
            return new QaJGivenReportModel<T>(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected QaJGivenReportModel(
        final QaJGivenReportModel.QaJGivenReportModelBuilder<T, ?, ?> b) {
        this.screenshotScale = b.screenshotScale;
        this.testDocumentId = b.testDocumentId;
        this.testDocumentRev = b.testDocumentRev;
        this.specDocumentId = b.specDocumentId;
        this.specDocumentRev = b.specDocumentRev;
        this.planDocumentId = b.planDocumentId;
        this.planDocumentRev = b.planDocumentRev;
        this.traceabilityDocumentId = b.traceabilityDocumentId;
        this.traceabilityDocumentRev = b.traceabilityDocumentRev;
        this.productName = b.productName;
        this.productVersion = b.productVersion;
        this.jgivenReport = b.jgivenReport;
        this.datePattern = b.datePattern;
        this.targetReportFile = b.targetReportFile;
    }

    @java.lang.SuppressWarnings("all")
    public static <T> QaJGivenReportModel.QaJGivenReportModelBuilder<T, ?, ?> builder() {
        return new QaJGivenReportModel.QaJGivenReportModelBuilderImpl<T>();
    }

    @java.lang.SuppressWarnings("all")
    public QaJGivenReportModel.QaJGivenReportModelBuilder<T, ?, ?> toBuilder() {
        return new QaJGivenReportModel.QaJGivenReportModelBuilderImpl<T>()
            .$fillValuesFrom(this);
    }
}
