// Generated by delombok at Wed Aug 30 12:58:32 UTC 2023
/*
 * Copyright 2023 Adrian Herscu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dev.aherscu.qa.jgiven.reporter;

import static dev.aherscu.qa.testing.utils.FileUtilsExtensions.*;

import java.io.*;

import org.apache.commons.io.*;
import org.testng.xml.*;

import com.google.gson.*;
import com.tngtech.jgiven.report.json.*;
import com.tngtech.jgiven.report.model.*;

import lombok.*;

/**
 * All in one report.
 */
public class QaJGivenReporter
    extends AbstractQaJgivenReporter<CompleteReportModel, QaJGivenReporter> {
    public static final String DEFAULT_TEMPLATE_RESOURCE =
        "/qa-jgiven-reporter.html";
    public final String        productName;
    public final String        productVersion;
    public final String        testDocumentId;
    public final String        testDocumentRev;
    public final String        specDocumentId;
    public final String        specDocumentRev;
    public final String        planDocumentId;
    public final String        planDocumentRev;
    public final String        traceabilityDocumentId;
    public final String        traceabilityDocumentRev;

    /**
     * Builds a new reporter configured with additional TestNG XML suite
     * parameters. Currently, only {@code templateResource} is recognized.
     *
     * @param xmlSuite
     *            TestNG XML suite
     * @return reporter configured
     */
    @Override
    protected QaJGivenReporter with(final XmlSuite xmlSuite) {
        return ((QaJGivenReporter) super.with(xmlSuite)).toBuilder()
            .templateResource(
                templateResourceParamFrom(xmlSuite, DEFAULT_TEMPLATE_RESOURCE))
            .build();
    }

    /**
     * Generates a report including all test classes by aggregating all JGiven
     * generated JSON files.
     */
    @Override
    public void generate() {
        try {
            final java.io.File targetReportFile = new File(outputDirectory,
                // FIXME Warning:(80, 13) Argument
                // 'FilenameUtils.getName(templateResource)' might be null
                FilenameUtils.getName(templateResource));
            // FIXME should supply a reportModelFile (a .json file)
            final dev.aherscu.qa.jgiven.reporter.QaJGivenReportModel<com.tngtech.jgiven.report.model.CompleteReportModel> aggregatedReportModel =
                reportModel(targetReportFile).toBuilder()
                    .jgivenReport(new ReportModelReader(QaJGivenReportConfig
                        .builder().sourceDir(sourceDirectory)
                        .targetDir(outputDirectory).build()).readDirectory())
                    .screenshotScale(screenshotScale).datePattern(datePattern)
                    .testDocumentId(testDocumentId)
                    .testDocumentRev(testDocumentRev)
                    .specDocumentId(specDocumentId)
                    .specDocumentRev(specDocumentRev)
                    .planDocumentId(planDocumentId)
                    .planDocumentRev(planDocumentRev)
                    .traceabilityDocumentId(traceabilityDocumentId)
                    .traceabilityDocumentRev(traceabilityDocumentRev)
                    .productName(productName).productVersion(productVersion)
                    .build();
            if (debug) {
                try (java.io.Writer debugReportWriter = fileWriter(
                    new File(outputDirectory, "debug-report.json"))) {
                    new GsonBuilder().setPrettyPrinting().create()
                        .toJson(aggregatedReportModel, debugReportWriter);
                }
            }
            try (java.io.Writer reportWriter = fileWriter(targetReportFile)) {
                template().execute(aggregatedReportModel, reportWriter);
            }
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
        // FIXME should work only with html reports
        // if (pdf) {
        // renderToPDF(
        // reportFile(reportModelFile, ".html"),
        // reportFile(reportModelFile, ".pdf")
        // .getAbsolutePath());
        // }
    }

    @java.lang.SuppressWarnings("all")
    public static abstract class QaJGivenReporterBuilder<C extends QaJGivenReporter, B extends QaJGivenReporter.QaJGivenReporterBuilder<C, B>>
        extends
        AbstractQaJgivenReporter.AbstractQaJgivenReporterBuilder<CompleteReportModel, QaJGivenReporter, C, B> {
        @java.lang.SuppressWarnings("all")
        private String productName;
        @java.lang.SuppressWarnings("all")
        private String productVersion;
        @java.lang.SuppressWarnings("all")
        private String testDocumentId;
        @java.lang.SuppressWarnings("all")
        private String testDocumentRev;
        @java.lang.SuppressWarnings("all")
        private String specDocumentId;
        @java.lang.SuppressWarnings("all")
        private String specDocumentRev;
        @java.lang.SuppressWarnings("all")
        private String planDocumentId;
        @java.lang.SuppressWarnings("all")
        private String planDocumentRev;
        @java.lang.SuppressWarnings("all")
        private String traceabilityDocumentId;
        @java.lang.SuppressWarnings("all")
        private String traceabilityDocumentRev;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QaJGivenReporter.QaJGivenReporterBuilder
                .$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(
            final QaJGivenReporter instance,
            final QaJGivenReporter.QaJGivenReporterBuilder<?, ?> b) {
            b.productName(instance.productName);
            b.productVersion(instance.productVersion);
            b.testDocumentId(instance.testDocumentId);
            b.testDocumentRev(instance.testDocumentRev);
            b.specDocumentId(instance.specDocumentId);
            b.specDocumentRev(instance.specDocumentRev);
            b.planDocumentId(instance.planDocumentId);
            b.planDocumentRev(instance.planDocumentRev);
            b.traceabilityDocumentId(instance.traceabilityDocumentId);
            b.traceabilityDocumentRev(instance.traceabilityDocumentRev);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public abstract C build();

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B productName(final String productName) {
            this.productName = productName;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B productVersion(final String productVersion) {
            this.productVersion = productVersion;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B testDocumentId(final String testDocumentId) {
            this.testDocumentId = testDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B testDocumentRev(final String testDocumentRev) {
            this.testDocumentRev = testDocumentRev;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B specDocumentId(final String specDocumentId) {
            this.specDocumentId = specDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B specDocumentRev(final String specDocumentRev) {
            this.specDocumentRev = specDocumentRev;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B planDocumentId(final String planDocumentId) {
            this.planDocumentId = planDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B planDocumentRev(final String planDocumentRev) {
            this.planDocumentRev = planDocumentRev;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B traceabilityDocumentId(final String traceabilityDocumentId) {
            this.traceabilityDocumentId = traceabilityDocumentId;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public B traceabilityDocumentRev(final String traceabilityDocumentRev) {
            this.traceabilityDocumentRev = traceabilityDocumentRev;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "QaJGivenReporter.QaJGivenReporterBuilder(super="
                + super.toString() + ", productName=" + this.productName
                + ", productVersion=" + this.productVersion
                + ", testDocumentId=" + this.testDocumentId
                + ", testDocumentRev=" + this.testDocumentRev
                + ", specDocumentId=" + this.specDocumentId
                + ", specDocumentRev=" + this.specDocumentRev
                + ", planDocumentId=" + this.planDocumentId
                + ", planDocumentRev=" + this.planDocumentRev
                + ", traceabilityDocumentId=" + this.traceabilityDocumentId
                + ", traceabilityDocumentRev=" + this.traceabilityDocumentRev
                + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    private static final class QaJGivenReporterBuilderImpl extends
        QaJGivenReporter.QaJGivenReporterBuilder<QaJGivenReporter, QaJGivenReporter.QaJGivenReporterBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private QaJGivenReporterBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected QaJGivenReporter.QaJGivenReporterBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public QaJGivenReporter build() {
            return new QaJGivenReporter(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected QaJGivenReporter(
        final QaJGivenReporter.QaJGivenReporterBuilder<?, ?> b) {
        super(b);
        this.productName = b.productName;
        this.productVersion = b.productVersion;
        this.testDocumentId = b.testDocumentId;
        this.testDocumentRev = b.testDocumentRev;
        this.specDocumentId = b.specDocumentId;
        this.specDocumentRev = b.specDocumentRev;
        this.planDocumentId = b.planDocumentId;
        this.planDocumentRev = b.planDocumentRev;
        this.traceabilityDocumentId = b.traceabilityDocumentId;
        this.traceabilityDocumentRev = b.traceabilityDocumentRev;
    }

    @java.lang.SuppressWarnings("all")
    public static QaJGivenReporter.QaJGivenReporterBuilder<?, ?> builder() {
        return new QaJGivenReporter.QaJGivenReporterBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public QaJGivenReporter.QaJGivenReporterBuilder<?, ?> toBuilder() {
        return new QaJGivenReporter.QaJGivenReporterBuilderImpl()
            .$fillValuesFrom(this);
    }

    @java.lang.SuppressWarnings("all")
    public QaJGivenReporter() {
        this.productName = null;
        this.productVersion = null;
        this.testDocumentId = null;
        this.testDocumentRev = null;
        this.specDocumentId = null;
        this.specDocumentRev = null;
        this.planDocumentId = null;
        this.planDocumentRev = null;
        this.traceabilityDocumentId = null;
        this.traceabilityDocumentRev = null;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "QaJGivenReporter(super=" + super.toString() + ", productName="
            + this.productName + ", productVersion=" + this.productVersion
            + ", testDocumentId=" + this.testDocumentId + ", testDocumentRev="
            + this.testDocumentRev + ", specDocumentId=" + this.specDocumentId
            + ", specDocumentRev=" + this.specDocumentRev + ", planDocumentId="
            + this.planDocumentId + ", planDocumentRev=" + this.planDocumentRev
            + ", traceabilityDocumentId=" + this.traceabilityDocumentId
            + ", traceabilityDocumentRev=" + this.traceabilityDocumentRev + ")";
    }
}
