/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.orcanos.publisher.maven.plugin;

import com.google.common.base.Splitter;
import dev.aherscu.qa.testing.utils.StringUtilsExtensions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="value object")
final class ReportHandle {
    static final String DEVICE_NAME = "DeviceName";
    static final String FAIL = "FAIL";
    static final String PASS = "PASS";
    static final String PLATFORM_NAME = "PlatformName";
    static final String PLATFORM_VERSION = "PlatformVersion";
    static final String REFERENCE = "dev.aherscu.qa.jgiven.commons.tags.Reference";
    static final String TAG_SEPARATOR = ":";
    private final File sourceFile;
    private final String status;
    private final String tag;
    private final Map<String, String> attributes;

    public String deviceName() {
        return this.attributes.get(DEVICE_NAME);
    }

    public String executionSetId() {
        return StringUtilsExtensions.substringAfter((String)this.reference(), (String)"_");
    }

    public boolean hasSupportedReference() {
        return this.reference().matches("\\d+_\\d+");
    }

    public boolean hasSupportedStatus() {
        return !Status.UNSUPPORTED.equals((Object)this.status());
    }

    public String platformName() {
        return this.attributes.get(PLATFORM_NAME);
    }

    public String platformVersion() {
        return this.attributes.get(PLATFORM_VERSION);
    }

    public String reference() {
        Iterable references = Splitter.onPattern((String)",").split((CharSequence)ObjectUtils.defaultIfNull((Object)this.attributes.get(REFERENCE), (Object)""));
        String defaultReference = "";
        for (String r : references) {
            Pair taggedReference;
            Pair pair = taggedReference = r.contains(TAG_SEPARATOR) ? Pair.of((Object)StringUtilsExtensions.substringBefore((String)r, (String)TAG_SEPARATOR), (Object)StringUtilsExtensions.substringAfter((String)r, (String)TAG_SEPARATOR)) : Pair.of((Object)"", (Object)r);
            if (defaultReference.isEmpty() && ((String)taggedReference.getKey()).equals("")) {
                defaultReference = (String)taggedReference.getValue();
            }
            if (!((String)taggedReference.getKey()).equals(this.tag)) continue;
            return (String)taggedReference.getValue();
        }
        return defaultReference;
    }

    public File sourceFile() {
        return this.sourceFile;
    }

    public Status status() {
        return Status.from(this.status);
    }

    public String testId() {
        return StringUtilsExtensions.substringBefore((String)this.reference(), (String)"_");
    }

    ReportHandle(File sourceFile, String status, String tag, Map<String, String> attributes) {
        this.sourceFile = sourceFile;
        this.status = status;
        this.tag = tag;
        this.attributes = attributes;
    }

    public static ReportHandleBuilder builder() {
        return new ReportHandleBuilder();
    }

    public String toString() {
        return "ReportHandle(sourceFile=" + this.sourceFile + ", status=" + this.status + ", tag=" + this.tag + ", attributes=" + this.attributes + ")";
    }

    public static class ReportHandleBuilder {
        private File sourceFile;
        private String status;
        private String tag;
        private Map<String, String> attributes;

        ReportHandleBuilder() {
        }

        public ReportHandleBuilder sourceFile(File sourceFile) {
            this.sourceFile = sourceFile;
            return this;
        }

        public ReportHandleBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ReportHandleBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public ReportHandleBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public ReportHandle build() {
            return new ReportHandle(this.sourceFile, this.status, this.tag, this.attributes);
        }

        public String toString() {
            return "ReportHandle.ReportHandleBuilder(sourceFile=" + this.sourceFile + ", status=" + this.status + ", tag=" + this.tag + ", attributes=" + this.attributes + ")";
        }
    }

    static enum Status {
        PASS,
        FAIL,
        UNSUPPORTED;

        public static final String FAILED = "FAILED";
        public static final String SUCCESS = "SUCCESS";

        static Status from(String value) {
            switch (String.valueOf(value)) {
                case "SUCCESS": {
                    return PASS;
                }
                case "FAILED": {
                    return FAIL;
                }
            }
            return UNSUPPORTED;
        }
    }
}

