/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.orcanos.publisher.maven.plugin;

import dev.aherscu.qa.jgiven.reporter.QaJGivenPerMethodReporter;
import dev.aherscu.qa.orcanos.publisher.maven.plugin.ReportHandle;
import dev.aherscu.qa.orcanos.publisher.maven.plugin.model.ExecutionSet;
import dev.aherscu.qa.orcanos.publisher.maven.plugin.model.ExecutionSetRunResults;
import dev.aherscu.qa.orcanos.publisher.maven.plugin.model.ExecutionSetRunResultsEx;
import dev.aherscu.qa.orcanos.publisher.maven.plugin.model.GenericResponse;
import dev.aherscu.qa.orcanos.publisher.maven.plugin.model.RecordExecutionResults;
import dev.aherscu.qa.testing.utils.FileUtilsExtensions;
import dev.aherscu.qa.testing.utils.TrustAllX509TrustManager;
import dev.aherscu.qa.testing.utils.UriUtils;
import dev.aherscu.qa.testing.utils.rest.AbstractJaxbReadableProvider;
import dev.aherscu.qa.testing.utils.rest.AutoCloseableClient;
import dev.aherscu.qa.testing.utils.rest.LoggingClientBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.rx.rxjava2.RxFlowableInvoker;
import org.glassfish.jersey.client.rx.rxjava2.RxFlowableInvokerProvider;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.jooq.lambda.Unchecked;

@Mojo(name="publish", threadSafe=true, defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class OrcanosPublisherMojo
extends AbstractMojo {
    static final String GET_EXECUTION_RUN_DETAILS = "Get_Execution_Run_Details_XML";
    static final String PROJECT_ID = "ProjectID";
    static final String RECORD_EXECUTION_RESULT = "Record_Execution_Results_New";
    static final String UPLOAD_ATTACHMENT = "QW_Add_MiscAttachment";
    @Parameter(property="orcanos.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project.build.directory}/jgiven-reports/qa-html")
    protected File reportsDirectory;
    @Parameter(defaultValue="(.*[\\\\|/])([^\\\\|/]+)-([^\\\\|/]+)-([^\\\\|/]+)$")
    protected String filePattern;
    @Parameter(defaultValue=".html")
    protected String reportFileExtension;
    @Parameter(required=true)
    protected URI orcanosUrl;
    @Parameter(required=true)
    protected String orcanosProjectId;
    @Parameter(defaultValue="10000")
    protected int connectTimeoutMs;
    @Parameter(defaultValue="10000")
    protected int readTimeoutMs;
    @Parameter(defaultValue="3")
    protected int retriesLimit;
    @Parameter
    protected String tag;
    @Parameter
    protected Properties additionalExecutionFields;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping");
            return;
        }
        this.getLog().info((CharSequence)("publishing to Orcanos from: " + this.reportsDirectory));
        this.getLog().info((CharSequence)("using file pattern: " + this.filePattern));
        this.getLog().info((CharSequence)("for files ending with: " + this.reportFileExtension));
        this.getLog().info((CharSequence)("Orcanos endpoint URL: " + this.orcanosUrl));
        this.getLog().info((CharSequence)("Orcanos Project ID: " + this.orcanosProjectId));
        this.getLog().info((CharSequence)("Connection timeout (ms): " + this.connectTimeoutMs));
        this.getLog().info((CharSequence)("Read timeout (ms): " + this.readTimeoutMs));
        this.getLog().info((CharSequence)("Retries limit: " + this.retriesLimit));
        this.getLog().info((CharSequence)("Tag: " + this.tag));
        this.getLog().info((CharSequence)("Additional execution fields: " + this.additionalExecutionFields));
        Pattern compiledReferencePattern = Pattern.compile(this.filePattern);
        try (AutoCloseableClient client = this.orcanosClient();){
            this.listReportFiles().stream().peek(file -> this.getLog().info((CharSequence)("found report: " + file.getName()))).map(file -> compiledReferencePattern.matcher(file.getAbsolutePath())).filter(Matcher::find).map(Unchecked.function(matcher -> ReportHandle.builder().sourceFile(new File(matcher.group(0))).status(matcher.group(2)).attributes(QaJGivenPerMethodReporter.readAttributesOf((File)new File(matcher.group(0)))).tag(this.tag).build())).peek(reportHandle -> this.getLog().info((CharSequence)("parsed meta-info: " + reportHandle.toString()))).filter(ReportHandle::hasSupportedStatus).filter(ReportHandle::hasSupportedReference).peek(reportHandle -> this.getLog().info((CharSequence)"meta-info supported")).forEach(reportHandle -> this.report(client.target(this.orcanosUrl), (ReportHandle)reportHandle));
        }
        catch (Throwable t) {
            throw new MojoExecutionException("configuration error", t);
        }
    }

    private Collection<File> listReportFiles() {
        Collection reportFiles = FileUtilsExtensions.listFiles((File)this.reportsDirectory, (IOFileFilter)new SuffixFileFilter(this.reportFileExtension), null);
        if (reportFiles.isEmpty()) {
            throw new RuntimeException("no reports to upload");
        }
        return reportFiles;
    }

    private AutoCloseableClient orcanosClient() {
        return new AutoCloseableClient((Client)((Client)((Client)((Client)((Client)LoggingClientBuilder.newClient().register(RxFlowableInvokerProvider.class)).register(MultiPartFeature.class)).register((Object)HttpAuthenticationFeature.basicBuilder().credentials(UriUtils.usernameFrom((URI)this.orcanosUrl), UriUtils.passwordFrom((URI)this.orcanosUrl)).build())).property("jersey.config.client.connectTimeout", (Object)this.connectTimeoutMs)).property("jersey.config.client.readTimeout", (Object)this.readTimeoutMs));
    }

    private GenericResponse recordExecutionResults(WebTarget orcanosEndpointTarget, ReportHandle reportHandle, ExecutionSetRunResultsEx results, GenericResponse uploadConfirmation) {
        this.getLog().info((CharSequence)MessageFormat.format("reporting run {0} of test case {1} on execution set {2} with status {3}", new Object[]{Objects.requireNonNull(results.getRun(), "couldn't get execution run result, check orcanos credentials").getName(), reportHandle.testId(), reportHandle.executionSetId(), reportHandle.status()}));
        return (GenericResponse)((RxFlowableInvoker)orcanosEndpointTarget.path(RECORD_EXECUTION_RESULT).request(new String[]{"application/json"}).rx(RxFlowableInvoker.class)).post(Entity.json((Object)RecordExecutionResults.builder().executionSetRunResults(results.withAdditionalFields(this.additionalExecutionFields).withDeviceInfo(reportHandle.deviceName(), reportHandle.platformName(), reportHandle.platformVersion()).withStatus(reportHandle.status().name()).withAttachment("click to open automation report", uploadConfirmation.href())).build()), GenericResponse.class).retry((long)this.retriesLimit, e -> e instanceof ProcessingException).blockingFirst();
    }

    private void report(WebTarget orcanosEndpointTarget, ReportHandle reportHandle) {
        UUID attachmentId = UUID.randomUUID();
        try (FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
             FileInputStream inputStream = FileUtilsExtensions.openInputStream((File)reportHandle.sourceFile());
             BufferedInputStream bufferedInputStream = IOUtils.buffer((InputStream)inputStream);
             MultiPart reportToUpload = formDataMultiPart.bodyPart((BodyPart)new StreamDataBodyPart(attachmentId.toString(), (InputStream)bufferedInputStream, attachmentId + this.reportFileExtension, MediaType.TEXT_HTML_TYPE));){
            this.getLog().info((CharSequence)this.recordExecutionResults(orcanosEndpointTarget, reportHandle, this.retrieveExecutionSetRunResults(orcanosEndpointTarget, reportHandle), this.uploadReport(orcanosEndpointTarget, reportToUpload)).toString());
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)reportHandle.toString(), t);
        }
    }

    private ExecutionSetRunResultsEx retrieveExecutionSetRunResults(WebTarget orcanosEndpointTarget, ReportHandle reportHandle) {
        return (ExecutionSetRunResultsEx)((RxFlowableInvoker)((WebTarget)orcanosEndpointTarget.register(ExecutionSetRunResultsProvider.class)).path(GET_EXECUTION_RUN_DETAILS).request(new String[]{"application/xml"}).rx(RxFlowableInvoker.class)).post(Entity.json((Object)ExecutionSet.builder().testId(reportHandle.testId()).executionSetId(reportHandle.executionSetId()).build()), ExecutionSetRunResultsEx.class).retry((long)this.retriesLimit, e -> e instanceof ProcessingException).blockingFirst();
    }

    private GenericResponse uploadReport(WebTarget orcanosEndpointTarget, MultiPart attachmentMultiPart) {
        return (GenericResponse)((RxFlowableInvoker)orcanosEndpointTarget.path(UPLOAD_ATTACHMENT).queryParam(PROJECT_ID, new Object[]{this.orcanosProjectId}).request(new String[]{"application/json"}).rx(RxFlowableInvoker.class)).post(Entity.entity((Object)attachmentMultiPart, (MediaType)attachmentMultiPart.getMediaType()), GenericResponse.class).retry((long)this.retriesLimit, e -> e instanceof ProcessingException).blockingFirst();
    }

    static {
        TrustAllX509TrustManager.disableSslCertificateValidation();
    }

    private static final class ExecutionSetRunResultsProvider
    extends AbstractJaxbReadableProvider<ExecutionSetRunResults> {
        private ExecutionSetRunResultsProvider() {
        }
    }
}

