/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.text.MessageFormat;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public final class EnumUtils {
    public static final Separator DEFAULT_ENUM_PREFIX = Separator.UNDERSCORE;
    public static final Separator DEFAULT_ENUM_SEPARATOR = Separator.UNDERSCORE;

    public static <E extends Enum<E>> E fromString(Class<E> enumType, String name) {
        return EnumUtils.fromString(enumType, name, DEFAULT_ENUM_PREFIX);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumType, String name, Separator prefix) {
        if (org.apache.commons.lang3.EnumUtils.isValidEnum(enumType, (String)(prefix.value + name))) {
            return (E)org.apache.commons.lang3.EnumUtils.getEnum(enumType, (String)(prefix.value + name));
        }
        throw new NoSuchMemberException(MessageFormat.format("enum {0} not found", name));
    }

    public static <E extends Enum<E>> String prettify(E e) {
        return EnumUtils.prettify(e, DEFAULT_ENUM_SEPARATOR);
    }

    public static <E extends Enum<E>> String prettify(@NotNull E e, @NotNull Separator separator) {
        return StringUtils.replaceChars((String)WordUtils.capitalize((String)e.name(), (char[])new char[]{separator.value}), (char)separator.value, (char)' ');
    }

    public static <E extends Enum<E>> String toString(E e) {
        return EnumUtils.toString(e, DEFAULT_ENUM_PREFIX);
    }

    public static <E extends Enum<E>> String toString(E e, Separator prefix) {
        return StringUtils.substringAfter((String)e.name(), (String)CharUtils.toString((char)prefix.value));
    }

    private EnumUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Separator {
        DOLLAR('$'),
        UNDERSCORE('_');

        public final char value;

        private Separator(char separatorChar) {
            this.value = separatorChar;
        }
    }

    public static final class NoSuchMemberException
    extends RuntimeException {
        public NoSuchMemberException(String message) {
            super(message);
        }
    }
}

