/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class ExecutorUtils {
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    });

    public static <T> T timeout(Callable<T> callable, Duration duration) throws Throwable {
        return (T)SimpleTimeLimiter.create((ExecutorService)EXECUTOR_SERVICE).callWithTimeout(callable, duration.getSeconds(), TimeUnit.SECONDS);
    }

    private ExecutorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

