/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public final class FileUtilsExtensions
extends FileUtils {
    public static void append(File sourceFile, File targetFile) throws IOException {
        try (LineIterator it = FileUtilsExtensions.lineIterator((File)sourceFile, (String)StandardCharsets.UTF_8.toString());){
            FileUtilsExtensions.writeLines((File)targetFile, (Collection)IteratorUtils.toList((Iterator)it), (boolean)true);
        }
    }

    public static File file(Class<?> clazz, String name) {
        return new File(clazz.getResource(name).getPath());
    }

    public static Reader fileReader(File from) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(from), StandardCharsets.UTF_8);
    }

    public static Writer fileWriter(File to) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(to), StandardCharsets.UTF_8);
    }

    public static String[] toSuffixes(String ... extensions) {
        String[] suffixes = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            suffixes[i] = "." + extensions[i];
        }
        return suffixes;
    }

    private FileUtilsExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

