/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import com.google.common.collect.ImmutableMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.tuple.Pair;

public final class ImageUtils {
    public static final Map<RenderingHints.Key, Object> DEFAULT_RENDERING_HINTS = ImmutableMap.builder().put((Object)RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR).build();
    public static final IndexColorModel FOUR_BIT_COLOR_MODEL;
    public static final IndexColorModel GREY_SCALE_COLOR_MODEL;

    public static BufferedImage reduce(BufferedImage inputImage, IndexColorModel indexColorModel) {
        BufferedImage outputReducedImage = new BufferedImage(inputImage.getWidth(), inputImage.getHeight(), 13, indexColorModel);
        Graphics2D g2 = outputReducedImage.createGraphics();
        g2.drawImage((Image)inputImage, 0, 0, null);
        g2.dispose();
        return outputReducedImage;
    }

    public static BufferedImage scale(BufferedImage inputImage, float widthScale, float heightScale, Map<RenderingHints.Key, Object> hints) {
        BufferedImage outputScaledImage = new BufferedImage(Math.round((float)inputImage.getWidth() * widthScale), Math.round((float)inputImage.getHeight() * heightScale), 13);
        Graphics2D g2 = outputScaledImage.createGraphics();
        g2.setRenderingHints(hints);
        g2.drawRenderedImage(inputImage, AffineTransform.getScaleInstance(widthScale, heightScale));
        g2.dispose();
        return outputScaledImage;
    }

    public static BufferedImage scale(BufferedImage inputImage, double widthScale, double heightScale) {
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{inputImage}).scale(widthScale, heightScale).asBufferedImage();
    }

    public static double areaOf(BufferedImage image) {
        return image.getWidth() * image.getHeight();
    }

    public static Pair<BufferedImage, BufferedImage> adapt(Pair<BufferedImage, BufferedImage> pair) {
        return ImageUtils.areaOf((BufferedImage)pair.getLeft()) < ImageUtils.areaOf((BufferedImage)pair.getRight()) ? Pair.of((Object)pair.getLeft(), (Object)Pipeline.from((BufferedImage)((BufferedImage)pair.getRight())).scale((double)(1.0 * (double)((BufferedImage)pair.getLeft()).getWidth() / (double)((BufferedImage)pair.getRight()).getWidth()), (double)(1.0 * (double)((BufferedImage)pair.getLeft()).getHeight() / (double)((BufferedImage)pair.getRight()).getHeight())).image) : Pair.of((Object)Pipeline.from((BufferedImage)((BufferedImage)pair.getLeft())).scale((double)(1.0 * (double)((BufferedImage)pair.getRight()).getWidth() / (double)((BufferedImage)pair.getLeft()).getWidth()), (double)(1.0 * (double)((BufferedImage)pair.getRight()).getHeight() / (double)((BufferedImage)pair.getLeft()).getHeight())).image, (Object)pair.getRight());
    }

    private ImageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        int SIZE = 256;
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            g[i] = b[i] = (byte)i;
            r[i] = b[i];
        }
        GREY_SCALE_COLOR_MODEL = new IndexColorModel(8, 256, r, g, b);
        int[] cmap = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0x808080, 0xC0C0C0, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
        FOUR_BIT_COLOR_MODEL = new IndexColorModel(4, cmap.length, cmap, 0, false, 1, 0);
    }

    public static class Pipeline {
        public final BufferedImage image;

        public static Pipeline from(BufferedImage image) {
            return new Pipeline(image);
        }

        public static Pipeline from(InputStream input) {
            return new Pipeline(ImageIO.read(input));
        }

        public <OUTPUT extends OutputStream> OUTPUT into(OUTPUT output, String format) {
            ImageIO.write((RenderedImage)this.image, format, output);
            return output;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <OUTPUT extends OutputStream> OUTPUT into(Supplier<OUTPUT> outputSupplier, String format) {
            try (OutputStream output = (OutputStream)outputSupplier.get();){
                OutputStream outputStream = this.into(output, format);
                return (OUTPUT)outputStream;
            }
        }

        public Pipeline map(UnaryOperator<Pipeline> pipeline) {
            return (Pipeline)pipeline.apply(this);
        }

        public Pipeline reduce(IndexColorModel indexColorModel) {
            return new Pipeline(ImageUtils.reduce(this.image, indexColorModel));
        }

        public Pipeline scale(double widthScale, double heightScale) {
            return new Pipeline(ImageUtils.scale(this.image, widthScale, heightScale));
        }

        public Pipeline scale(float widthScale, float heightScale, Map<RenderingHints.Key, Object> hints) {
            return new Pipeline(ImageUtils.scale(this.image, widthScale, heightScale, hints));
        }

        public <D> D diff(BufferedImage other, Function<Pair<BufferedImage, BufferedImage>, D> differentiator, Function<Pair<BufferedImage, BufferedImage>, Pair<BufferedImage, BufferedImage>> adapter) {
            return differentiator.apply(adapter.apply((Pair<BufferedImage, BufferedImage>)Pair.of((Object)this.image, (Object)other)));
        }

        public <D> D diff(BufferedImage other, Function<Pair<BufferedImage, BufferedImage>, D> differentiator) {
            return this.diff(other, differentiator, Function.identity());
        }

        public Pipeline(BufferedImage image) {
            this.image = image;
        }
    }
}

