/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import com.google.common.collect.Ordering;
import dev.aherscu.qa.tester.utils.NumberUtils;
import dev.aherscu.qa.tester.utils.StringUtilsExtensions;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.ThreadSafe;
import jcurry.util.Currying;
import jcurry.util.function.CurryingBiFunction;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.BooleanUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

@ThreadSafe
public class MatchersExtensions
extends Matchers {
    public static <T, R> Matcher<Iterable<T>> adapted(final Function<T, R> converter, final Matcher<Iterable<R>> matcher) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(Iterable<T> actual) {
                return matcher.matches(StreamSupport.stream(actual.spliterator(), false).map(converter).collect(Collectors.toList()));
            }
        };
    }

    public static <T, R> Matcher<Iterable<T>> adaptedByJXPath(final String jxpath, final Matcher<Iterable<R>> matcher) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(Iterable<T> actual) {
                return matcher.matches(StreamSupport.stream(actual.spliterator(), false).map(object -> JXPathContext.newContext((Object)object).getValue(jxpath)).collect(Collectors.toList()));
            }
        };
    }

    public static Matcher<Stream<String>> adaptedByRegex(final String regex, final Matcher<Stream<String>> matcher) {
        return new TypeSafeMatcher<Stream<String>>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(Stream<String> actual) {
                return matcher.matches(StreamSupport.stream(actual.spliterator(), false).map(s -> StringUtilsExtensions.substring(s, Pattern.compile(regex))).collect(Collectors.toList()));
            }
        };
    }

    public static <T> Matcher<Collection<T>> adaptedCollectionToIterableMatcher(final Matcher<Iterable<T>> matcher) {
        return new TypeSafeMatcher<Collection<T>>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(Collection<T> actual) {
                return matcher.matches(actual);
            }
        };
    }

    public static <T> Matcher<Iterable<T>> adaptedIterableToCollectionMatcher(final Matcher<Collection<T>> matcher) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(Iterable<T> actual) {
                return matcher.matches(actual);
            }
        };
    }

    public static <T, R> Matcher<T> adaptedObject(final Function<T, R> converter, final Matcher<R> matcher) {
        return new TypeSafeMatcher<T>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(T actual) {
                return matcher.matches(converter.apply(actual));
            }
        };
    }

    public static Matcher<String> adaptedStringToBooleanMatcher(final Matcher<Boolean> booleanMatcher) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)booleanMatcher);
            }

            protected boolean matchesSafely(String actual) {
                return booleanMatcher.matches((Object)BooleanUtils.toBoolean((String)actual));
            }
        };
    }

    @SafeVarargs
    public static Matcher<String> adaptedStringToNumericMatcher(final Matcher<? extends Number> numericMatcher, final Class<? extends Number> ... typeOfExpectedNumber) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)numericMatcher);
            }

            protected boolean matchesSafely(String actual) {
                return org.apache.commons.lang3.math.NumberUtils.isCreatable((String)actual) && numericMatcher.matches((Object)NumberUtils.numericValueOf(actual, typeOfExpectedNumber));
            }
        };
    }

    public static Matcher<Number> adaptedTypeOfNumericMatcher(final Matcher<? extends Number> numericMatcher, final Class<? extends Number> targetType) {
        return new TypeSafeMatcher<Number>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)numericMatcher);
            }

            protected boolean matchesSafely(Number actual) {
                return numericMatcher.matches(targetType.cast(actual));
            }
        };
    }

    public static <T> Matcher<Collection<T>> collection(Matcher<Collection<? extends T>> matcher) {
        return matcher;
    }

    public static <C, MR extends Matcher<?>, MT extends Matcher<?>> CurryingBiFunction<C, MR, MT> curriedAdapter(BiFunction<C, MR, MT> adapted) {
        return Currying.biFunction(adapted);
    }

    public static <T> Matcher<Iterable<T>> iterable(Matcher<Iterable<? extends T>> matcher) {
        return matcher;
    }

    public static <T> Matcher<Iterable<T>> iterableSuper(Matcher<Iterable<? super T>> matcher) {
        return matcher;
    }

    public static <T> Matcher<Iterable<T>> ordered(final Ordering<T> ordering) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public void describeTo(Description description) {
                description.appendText(ordering.toString());
            }

            protected boolean matchesSafely(Iterable<T> actual) {
                return ordering.isOrdered(actual);
            }
        };
    }
}

