/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import dev.aherscu.qa.tester.utils.ArrayUtilsExtensions;
import java.lang.reflect.InvocationTargetException;

public final class NumberUtils {
    @SafeVarargs
    public static Number numericValueOf(String text, Class<? extends Number> ... expectedNumericType) {
        try {
            return (Number)ArrayUtilsExtensions.defaultIfEmpty(expectedNumericType, Double.class).getMethod("valueOf", String.class).invoke(null, text);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static int parseIntOrZero(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long parseLongOrZero(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static double safeDoubleOf(Number number) {
        return null != number ? number.doubleValue() : Double.NaN;
    }

    private NumberUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

