/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import dev.aherscu.qa.tester.utils.StringUtilsExtensions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

@ThreadSafe
public final class ObjectUtilsExtensions
extends ObjectUtils {
    @SafeVarargs
    public static <T> T defaultIfNull(T ... values) {
        return ObjectUtilsExtensions.defaultIfNull(null, values);
    }

    @SafeVarargs
    public static <T> T defaultIfNull(T defaultValue, T ... values) {
        return (T)ObjectUtils.defaultIfNull((Object)ObjectUtils.firstNonNull((Object[])values), defaultValue);
    }

    public static <T> T requireNonNull(T obj, String message) {
        return ObjectUtilsExtensions.requireNonNull(obj, new IllegalStateException(message));
    }

    public static <T> T requireNonNull(T obj, RuntimeException e) {
        if (null == obj) {
            throw e;
        }
        return obj;
    }

    public static String toString(Object obj, String separator, int length) {
        HashMap<String, String> fields = new HashMap<String, String>();
        try {
            for (Field field : FieldUtils.getAllFieldsList(obj.getClass())) {
                fields.put(field.getName(), StringUtilsExtensions.abbreviateMiddle(Objects.toString(field.get(obj)), "...", length));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return StringUtilsExtensions.join((Object[])new Object[]{fields, separator});
    }

    private ObjectUtilsExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

