/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelLoop {
    private static final Logger log = LoggerFactory.getLogger(ParallelLoop.class);
    public static final ParallelLoop PROTOTYPE = new ParallelLoop();
    private final AbstractExecutorService threadPool;
    private final int repetitions;

    public ParallelLoop() {
        this.threadPool = new ForkJoinPool(1);
        this.repetitions = 1;
    }

    public void run(Function<Integer, Integer> function) {
        this.threadPool.submit(() -> {
            IntStream.range(0, this.repetitions).parallel().forEach(id -> log.trace("run id {}", function.apply(id)));
            return null;
        }).get();
    }

    public void run(IntConsumer consumer) {
        this.run((Integer id) -> {
            consumer.accept((int)id);
            return id;
        });
    }

    public ParallelLoop(AbstractExecutorService threadPool, int repetitions) {
        this.threadPool = threadPool;
        this.repetitions = repetitions;
    }

    public ParallelLoop withThreadPool(AbstractExecutorService threadPool) {
        return this.threadPool == threadPool ? this : new ParallelLoop(threadPool, this.repetitions);
    }

    public ParallelLoop withRepetitions(int repetitions) {
        return this.repetitions == repetitions ? this : new ParallelLoop(this.threadPool, repetitions);
    }
}

