/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.text.MessageFormat;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
public final class RandomUtils {
    public static final int DEFAULT_RANDOM_STRING_LENGTH = 4;
    private static final ThreadLocal<String> lastRandomString = new ThreadLocal();

    public static String lastRandomAlphaNumeric(String template) {
        return MessageFormat.format(template, StringUtils.defaultString((String)lastRandomString.get()));
    }

    public static String padRandomAlphaNumeric(String template, int length) {
        int templateLength = MessageFormat.format(template, "").length();
        return RandomUtils.randomAlphaNumeric(template, length - templateLength);
    }

    public static String randomAlphaNumeric(String template) {
        return RandomUtils.randomAlphaNumeric(template, 4);
    }

    public static String randomAlphaNumeric(String template, int randomStringLength) {
        String randomAlphanumeric = RandomStringUtils.randomAlphanumeric((int)randomStringLength);
        lastRandomString.set(randomAlphanumeric);
        return MessageFormat.format(template, randomAlphanumeric);
    }

    private RandomUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

