/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangeSpliterator<C extends Spliterator<T>, T>
implements Spliterator<T> {
    private static final Logger log = LoggerFactory.getLogger(RangeSpliterator.class);
    private final long atom;
    private Range<Long> range;
    private long index = -1L;

    public RangeSpliterator(Range<Long> range) {
        this(range, 1L);
    }

    public RangeSpliterator(Range<Long> range, long atom) {
        this.range = range;
        this.atom = atom;
        log.debug("inited with size {}, atom {}, spanning {}", new Object[]{this.estimateSize(), atom, range});
    }

    @Override
    public final boolean tryAdvance(Consumer<? super T> action) {
        log.debug("before advance: current item {} within {}", (Object)this.index, this.range);
        if (this.hasNext()) {
            action.accept(this.item(this.next()));
            return true;
        }
        log.debug("no more items");
        return false;
    }

    public final C trySplit() {
        if (this.estimateSize() <= this.atom) {
            log.debug("chunk size {} is less/equal than atom {}; can no longer split", (Object)this.estimateSize(), (Object)this.atom);
            return null;
        }
        log.debug("before split: chunk size {} spanning {}", (Object)this.estimateSize(), this.range);
        Long oldStartIndexForChunk = (Long)this.range.getMinimum();
        long chunkSize = this.estimateSize();
        this.range = Range.between((Comparable)Long.valueOf((Long)this.range.getMinimum() + chunkSize / 2L), (Comparable)((Comparable)this.range.getMaximum()));
        return this.subSpliterator((Range<Long>)Range.between((Comparable)oldStartIndexForChunk, (Comparable)Long.valueOf(oldStartIndexForChunk + chunkSize / 2L - 1L)));
    }

    @Override
    public final long estimateSize() {
        return (Long)this.range.getMaximum() - (Long)this.range.getMinimum() + 1L;
    }

    @Override
    public final int characteristics() {
        return 320;
    }

    protected abstract T item(long var1);

    protected abstract C subSpliterator(Range<Long> var1);

    private boolean hasNext() {
        return this.index < (Long)this.range.getMaximum();
    }

    private long next() {
        return this.index < (Long)this.range.getMinimum() ? (this.index = ((Long)this.range.getMinimum()).longValue()) : (this.index = this.index + 1L);
    }
}

