/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadMultiWriteLock {
    private static final Logger log = LoggerFactory.getLogger(ReadMultiWriteLock.class);
    private static final ReadMultiWriteLock lock = new ReadMultiWriteLock();
    private int readers = 0;
    private int writers = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readLocking(Callable<T> criticalSection) {
        lock.readingAquire();
        try {
            T t = criticalSection.call();
            return t;
        }
        finally {
            lock.readingRelease();
        }
    }

    public static void readLocking(Runnable criticalSection) {
        ReadMultiWriteLock.readLocking(Executors.callable(criticalSection));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T writeLocking(Callable<T> criticalSection) {
        lock.writingAcquire();
        try {
            T t = criticalSection.call();
            return t;
        }
        finally {
            lock.writingRelease();
        }
    }

    public static void writeLocking(Runnable criticalSection) {
        ReadMultiWriteLock.writeLocking(Executors.callable(criticalSection));
    }

    public synchronized void readingAquire() throws InterruptedException {
        while (this.writers > 0) {
            log.trace("blocking read -- {} writers running", (Object)this.writers);
            this.wait();
        }
        ++this.readers;
        log.trace("aquired {} reading locks", (Object)this.readers);
    }

    public synchronized void readingRelease() {
        --this.readers;
        this.notifyAll();
    }

    public synchronized void writingAcquire() throws InterruptedException {
        while (this.readers > 0) {
            log.trace("blocking write -- {} readers running", (Object)this.readers);
            this.wait();
        }
        ++this.writers;
        log.trace("aquired {} writing locks", (Object)this.writers);
    }

    public synchronized void writingRelease() throws InterruptedException {
        --this.writers;
        this.notifyAll();
    }
}

