/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import uk.co.probablyfine.matchers.StreamMatchers;

@ThreadSafe
public class StreamMatchersExtensions
extends StreamMatchers {
    public static <T> Matcher<Stream<T>> adapt(final Supplier<Collection<T>> supplier, final Matcher<Iterable<T>> matcher) {
        return new TypeSafeMatcher<Stream<T>>(){
            private Iterable<T> actualCollected;

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(Stream<T> actual) {
                this.actualCollected = (Iterable)actual.collect(Collectors.toCollection(supplier));
                return matcher.matches(this.actualCollected);
            }

            public void describeMismatchSafely(Stream<T> actual, Description description) {
                description.appendText("was a list of " + this.actualCollected + " items");
            }
        };
    }

    public static <T, R> Matcher<Stream<T>> adaptedStream(final Function<T, R> converter, final Matcher<Stream<R>> matcher) {
        return new StreamMatcher<T>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(Stream<T> actual) {
                this.accumulator = new LinkedList();
                return matcher.matches(actual.peek(this.accumulator::add).map(converter));
            }
        };
    }

    public static <T> Matcher<Stream<T>> anyStream(final String ... message) {
        return new TypeSafeMatcher<Stream<T>>(){

            public void describeTo(Description description) {
                description.appendText(Arrays.toString(message));
            }

            protected boolean matchesSafely(Stream<T> dontcare) {
                return true;
            }
        };
    }

    public static <T> Matcher<Stream<T>> counts(long expectedNumberOfItems) {
        return StreamMatchersExtensions.counts((Matcher<Long>)Matchers.is((Object)expectedNumberOfItems));
    }

    public static <T> Matcher<Stream<T>> counts(final Matcher<Long> expectedNumberOfItems) {
        return new TypeSafeMatcher<Stream<T>>(){
            private long actualCount;

            public void describeTo(Description description) {
                description.appendText("contains " + expectedNumberOfItems + " items");
            }

            protected boolean matchesSafely(Stream<T> actual) {
                this.actualCount = actual.count();
                return expectedNumberOfItems.matches((Object)this.actualCount);
            }

            public void describeMismatchSafely(Stream<T> actual, Description description) {
                description.appendText("was a stream producing " + this.actualCount + " items");
            }
        };
    }

    public static <T> Matcher<Stream<T>> emptyStream() {
        return new TypeSafeMatcher<Stream<T>>(){
            private Iterator<T> actualIterator;

            public void describeTo(Description description) {
                description.appendText("an empty Stream");
            }

            protected boolean matchesSafely(Stream<T> actual) {
                this.actualIterator = actual.iterator();
                return !this.actualIterator.hasNext();
            }

            @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="this method is always called after matchesSafely")
            protected void describeMismatchSafely(Stream<T> item, Description description) {
                description.appendText("was non empty Stream starting with ").appendValue(this.actualIterator.next());
            }
        };
    }

    public static <T> Matcher<Stream<T>> hasItemsMatching(final List<Matcher<T>> matchers) {
        return new StreamMatcher<T>(){

            public void describeTo(Description description) {
                description.appendText("to match a sequence of following: ").appendValueList("[", ",", "]", (Iterable)matchers);
            }

            protected boolean matchesSafely(Stream<T> actual) {
                if (matchers.isEmpty() && !actual.findAny().isPresent()) {
                    return true;
                }
                this.accumulator = new LinkedList();
                Iterator actualIterator = actual.iterator();
                int index = 0;
                while (actualIterator.hasNext()) {
                    Object object = actualIterator.next();
                    this.accumulator.add(object);
                    if (!((Matcher)matchers.get(index)).matches(object) || ++index < matchers.size()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T> Matcher<Stream<T>> hasItemsMatching(Matcher<T> ... values) {
        return StreamMatchersExtensions.hasItemsMatching(ImmutableList.copyOf((Object[])values));
    }

    public static <T> Matcher<Stream<T>> hasItemsMatchingInAnyOrder(final Set<Matcher<T>> matchers) {
        final HashSet<Matcher<T>> toBeMatched = new HashSet<Matcher<T>>(matchers);
        return new StreamMatcher<T>(){

            public void describeTo(Description description) {
                description.appendText("to match a sequence of following in any order: ").appendValueList("[", ",", "]", (Iterable)matchers);
            }

            protected boolean matchesSafely(Stream<T> actual) {
                if (matchers.isEmpty() && !actual.findAny().isPresent()) {
                    return true;
                }
                this.accumulator = new LinkedList();
                Iterator actualIterator = actual.iterator();
                while (actualIterator.hasNext()) {
                    Object object = actualIterator.next();
                    this.accumulator.add(object);
                    toBeMatched.removeIf(matcher -> matcher.matches(object));
                    if (!toBeMatched.isEmpty()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T> Matcher<Stream<T>> hasItemsMatchingInAnyOrder(Matcher<T> ... values) {
        return StreamMatchersExtensions.hasItemsMatchingInAnyOrder(ImmutableSet.copyOf((Object[])values));
    }

    public static <T> Matcher<Stream<T>> hasSpecificItems(List<T> values) {
        return StreamMatchersExtensions.hasItemsMatching(values.stream().map(CoreMatchers::is).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> Matcher<Stream<T>> hasSpecificItems(T ... values) {
        return StreamMatchersExtensions.hasSpecificItems(Lists.newArrayList((Object[])values));
    }

    @SafeVarargs
    public static <T> Matcher<Stream<T>> hasSpecificItemsInAnyOrder(T ... values) {
        return StreamMatchersExtensions.hasSpecificItemsInAnyOrder(ImmutableSet.copyOf((Object[])values));
    }

    public static <T> Matcher<Stream<T>> hasSpecificItemsInAnyOrder(Set<T> values) {
        return StreamMatchersExtensions.hasItemsMatchingInAnyOrder(values.stream().map(CoreMatchers::is).collect(Collectors.toSet()));
    }

    public static <T> Matcher<Stream<T>> orderedStream(final Ordering<T> ordering) {
        return new StreamMatcher<T>(){

            public void describeTo(Description description) {
                description.appendText(ordering.toString());
            }

            protected boolean matchesSafely(Stream<T> actual) {
                this.accumulator = new LinkedList();
                actual.forEach(this.accumulator::add);
                return ordering.isOrdered((Iterable)this.accumulator);
            }
        };
    }

    public static <T> Matcher<Stream<T>> scanningAtMost(final int limit, final Matcher<Stream<T>> matcher) {
        return new StreamMatcher<T>(){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)matcher).appendText(" scanning at most ").appendValue((Object)limit);
            }

            protected boolean matchesSafely(Stream<T> actual) {
                this.accumulator = new LinkedList();
                return matcher.matches(actual.peek(this.accumulator::add).limit(limit));
            }
        };
    }

    private static abstract class StreamMatcher<T>
    extends TypeSafeMatcher<Stream<T>> {
        protected Collection<T> accumulator;

        private StreamMatcher() {
        }

        public void describeMismatchSafely(Stream<T> actual, Description description) {
            description.appendText("was a stream producing ").appendValueList("[", ",", "]", this.accumulator);
        }
    }
}

