/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
public class StringUtilsExtensions
extends StringUtils {
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOT = ".";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String ELLIPSIS = "...";
    public static final String EQUAL = "=";
    public static final String QUOTE = "'";
    public static final String SEMI = ";";
    public static final String SLASH = "/";
    public static final String UNDERSCORE = "_";

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate((String)str, (int)maxWidth) + StringUtilsExtensions.ifExcessiveLength(str, maxWidth);
    }

    public static String abbreviateMiddle(String str, String middle, int length) {
        return StringUtils.abbreviateMiddle((String)str, (String)middle, (int)length) + StringUtilsExtensions.ifExcessiveLength(str, length);
    }

    public static String format(String template, Pattern pattern, String string) {
        return MessageFormat.format(template, StringUtilsExtensions.groups(pattern, string).toArray());
    }

    public static String format(String template, String pattern, String string) {
        return MessageFormat.format(template, StringUtilsExtensions.groups(pattern, string).toArray());
    }

    public static Collection<String> groups(Pattern pattern, String string) {
        LinkedList<String> allMatches = new LinkedList<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                allMatches.add(matcher.group(i));
            }
        }
        return allMatches;
    }

    public static Collection<String> groups(String pattern, String string) {
        return StringUtilsExtensions.groups(Pattern.compile(pattern), string);
    }

    public static String ifExcessiveLength(String str, int allowedLength) {
        return str.length() > allowedLength ? StringUtilsExtensions.length(str) : "";
    }

    public static String left(String str, int length) {
        return StringUtils.left((String)str, (int)length) + StringUtilsExtensions.ifExcessiveLength(str, length);
    }

    public static String length(String str) {
        return StringUtilsExtensions.length(str, "(%d chars)");
    }

    public static String length(String str, String format) {
        return String.format(format, str.length());
    }

    public static String prettified(String string) {
        return null == string ? "<<null>>" : (StringUtilsExtensions.isEmpty((CharSequence)string) ? "<<empty>>" : (StringUtilsExtensions.isBlank((CharSequence)string) ? "<<blank>>" : string));
    }

    public static String substring(String s, Pattern regex) {
        Matcher matcher = regex.matcher(s);
        return matcher.find() ? matcher.group() : "";
    }

    public static String toUnix(String str) {
        return StringUtilsExtensions.replace((String)str, (String)"\r\n", (String)"\n");
    }
}

