/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import dev.aherscu.qa.tester.utils.FileUtilsExtensions;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateUtils {
    public static Loader using(Mustache.Compiler compiler) {
        return new Loader(compiler);
    }

    private TemplateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Loader {
        private static final Logger log = LoggerFactory.getLogger(Loader.class);
        final Mustache.Compiler compiler;

        public Loader(Mustache.Compiler compiler) {
            this.compiler = compiler;
        }

        public Template loadFrom(File file) throws IOException {
            log.debug("loading template from {}", (Object)file.toString());
            try (Reader fileReader = FileUtilsExtensions.fileReader(file);){
                Template template = this.loadFrom(fileReader);
                return template;
            }
        }

        public Template loadFrom(Reader reader) {
            return this.compiler.defaultValue("").compile(reader);
        }

        public Template loadFrom(String name) {
            log.debug("loading template resource from {}", (Object)name);
            return this.loadFrom(new InputStreamReader(TemplateUtils.class.getResourceAsStream(name), StandardCharsets.UTF_8));
        }
    }
}

