/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustAllX509TrustManager
implements X509TrustManager {
    private static final Logger log = LoggerFactory.getLogger(TrustAllX509TrustManager.class);
    public static final SSLContext TRUST_ALL_SSL_CONTEXT = TrustAllX509TrustManager.trustAllSslContext();

    public static void disableSslCertificateValidation() {
        log.debug("turning off SSL certificate validation");
        SSLContext.setDefault(TRUST_ALL_SSL_CONTEXT);
        HttpsURLConnection.setDefaultSSLSocketFactory(TRUST_ALL_SSL_CONTEXT.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((string, ssls) -> true);
    }

    private static SSLContext trustAllSslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new TrustAllX509TrustManager()}, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("could not initialize a trusting all SSL context due to {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) {
        log.trace("client trusted {} -> {}", (Object)authType, (Object)certs);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) {
        log.trace("server trusted {} -> {}", (Object)authType, (Object)certs);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        log.trace("accepting all issuers");
        return new X509Certificate[0];
    }
}

