/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils;

import dev.aherscu.qa.tester.utils.StringUtilsExtensions;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;

public class UriUtils {
    public static String lastSegmentOf(URI url) {
        return new File(url.getPath()).getName();
    }

    public static List<String> listOfStringsFrom(List<URI> uris) {
        return uris.stream().map(URI::toString).collect(Collectors.toList());
    }

    public static String passwordFrom(URI url) {
        return StringUtilsExtensions.substringAfter((String)url.getUserInfo(), (String)":");
    }

    public static String pathSegmentFrom(URI url, int n) {
        return url.getPath().split("/")[n + 1];
    }

    public static URI quietUriFrom(String url) {
        return new URI(url);
    }

    public static URI stripUserInfoFrom(URI url) {
        return UriUtils.quietUriFrom(url.toString().replace(url.getUserInfo() + "@", ""));
    }

    public static String usernameFrom(URI url) {
        return StringUtilsExtensions.substringBefore((String)url.getUserInfo(), (String)":");
    }
}

