/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.assertions;

import dev.aherscu.qa.tester.utils.StringUtilsExtensions;
import dev.aherscu.qa.tester.utils.assertions.JXPathAsserter;
import dev.aherscu.qa.tester.utils.assertions.JXPathAssertion;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.assertj.core.api.Assertions;

public class JXPathAsserterImpl
implements JXPathAsserter {
    private final JXPathContext context;

    public JXPathAsserterImpl(Object object) {
        this.context = JXPathContext.newContext((Object)object);
    }

    @Override
    public JXPathAsserter assertHas(Iterable<? extends JXPathAssertion<?>> expectedContents) {
        ArrayList<String> assertionErrors = new ArrayList<String>();
        int counter = 0;
        for (JXPathAssertion<?> jxpathAssertion : expectedContents) {
            try {
                if (null != jxpathAssertion.getRight()) {
                    Assertions.assertThat((Object)this.context.getValue((String)jxpathAssertion.left)).isEqualTo(jxpathAssertion.right);
                    continue;
                }
                Assertions.assertThatThrownBy(() -> this.context.getValue((String)jxpathAssertion.left)).isInstanceOf(JXPathNotFoundException.class);
            }
            catch (AssertionError e) {
                assertionErrors.add(String.format("%d) %s", ++counter, ((Throwable)((Object)e)).getMessage()));
            }
        }
        if (!assertionErrors.isEmpty()) {
            throw new AssertionError((Object)StringUtilsExtensions.join(assertionErrors, (String)";\r\n"));
        }
        return this;
    }

    @Override
    public JXPathAsserter assertHas(JXPathAssertion<?> ... expectedContents) {
        return this.assertHas(Arrays.asList(expectedContents));
    }
}

