/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.assertions;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonassert.impl.JsonAsserterImpl;
import dev.aherscu.qa.tester.utils.StringUtilsExtensions;
import dev.aherscu.qa.tester.utils.assertions.JsonAsserterEx;
import dev.aherscu.qa.tester.utils.assertions.JsonAssertion;
import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Matcher;

final class JsonAsserterExImpl
extends JsonAsserterImpl
implements JsonAsserterEx {
    public JsonAsserterExImpl(Object jsonObject) {
        super(jsonObject);
    }

    @Override
    public JsonAsserter assertHas(Iterable<? extends JsonAssertion<?>> expectedContents) {
        ArrayList<String> assertionErrors = new ArrayList<String>();
        int counter = 0;
        for (JsonAssertion<?> jsonAssertion : expectedContents) {
            try {
                if (null != jsonAssertion.getRight()) {
                    this.assertThat((String)jsonAssertion.getLeft(), (Matcher)jsonAssertion.getRight());
                    continue;
                }
                this.assertNotDefined((String)jsonAssertion.getLeft());
            }
            catch (AssertionError e) {
                assertionErrors.add(String.format("%d) %s", ++counter, ((Throwable)((Object)e)).getMessage()));
            }
        }
        if (!assertionErrors.isEmpty()) {
            throw new AssertionError((Object)StringUtilsExtensions.join(assertionErrors, (String)";\r\n"));
        }
        return this;
    }

    @Override
    public JsonAsserter assertHas(JsonAssertion<?> ... expectedContents) {
        return this.assertHas(Arrays.asList(expectedContents));
    }
}

