/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.config;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;

public abstract class AbstractConfiguration<T extends Configuration>
implements Configuration,
Map<Object, Object> {
    public static final String CONFIGURATION_SOURCES = "configuration-sources.xml";
    protected final T wrappedConfiguration;

    protected AbstractConfiguration(T wrappedConfiguration) {
        this.wrappedConfiguration = wrappedConfiguration;
        if (wrappedConfiguration instanceof org.apache.commons.configuration.AbstractConfiguration) {
            ((org.apache.commons.configuration.AbstractConfiguration)wrappedConfiguration).setThrowExceptionOnMissing(true);
        }
    }

    public static Configuration defaultConfiguration() throws ConfigurationException {
        return new DefaultConfigurationBuilder(CONFIGURATION_SOURCES).getConfiguration();
    }

    public String resolve(Object value) {
        return StringSubstitutor.replace((Object)value, (Properties)ConfigurationConverter.getProperties((Configuration)this));
    }

    protected String stringResourceFrom(String path) {
        return IOUtils.toString((URL)Objects.requireNonNull(this.getClass().getClassLoader().getResource(path), "cannot find or access resource"), (Charset)StandardCharsets.UTF_8);
    }

    private Map<Object, Object> getAsProperties() {
        return ConfigurationConverter.getProperties(this.wrappedConfiguration);
    }

    public Configuration subset(String arg0) {
        return this.wrappedConfiguration.subset(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedConfiguration.isEmpty();
    }

    public boolean containsKey(String arg0) {
        return this.wrappedConfiguration.containsKey(arg0);
    }

    public void addProperty(String arg0, Object arg1) {
        this.wrappedConfiguration.addProperty(arg0, arg1);
    }

    public void setProperty(String arg0, Object arg1) {
        this.wrappedConfiguration.setProperty(arg0, arg1);
    }

    public void clearProperty(String arg0) {
        this.wrappedConfiguration.clearProperty(arg0);
    }

    @Override
    public void clear() {
        this.wrappedConfiguration.clear();
    }

    public Object getProperty(String arg0) {
        return this.wrappedConfiguration.getProperty(arg0);
    }

    public Iterator<String> getKeys(String arg0) {
        return this.wrappedConfiguration.getKeys(arg0);
    }

    public Iterator<String> getKeys() {
        return this.wrappedConfiguration.getKeys();
    }

    public Properties getProperties(String arg0) {
        return this.wrappedConfiguration.getProperties(arg0);
    }

    public boolean getBoolean(String arg0) {
        return this.wrappedConfiguration.getBoolean(arg0);
    }

    public boolean getBoolean(String arg0, boolean arg1) {
        return this.wrappedConfiguration.getBoolean(arg0, arg1);
    }

    public Boolean getBoolean(String arg0, Boolean arg1) {
        return this.wrappedConfiguration.getBoolean(arg0, arg1);
    }

    public byte getByte(String arg0) {
        return this.wrappedConfiguration.getByte(arg0);
    }

    public byte getByte(String arg0, byte arg1) {
        return this.wrappedConfiguration.getByte(arg0, arg1);
    }

    public Byte getByte(String arg0, Byte arg1) {
        return this.wrappedConfiguration.getByte(arg0, arg1);
    }

    public double getDouble(String arg0) {
        return this.wrappedConfiguration.getDouble(arg0);
    }

    public double getDouble(String arg0, double arg1) {
        return this.wrappedConfiguration.getDouble(arg0, arg1);
    }

    public Double getDouble(String arg0, Double arg1) {
        return this.wrappedConfiguration.getDouble(arg0, arg1);
    }

    public float getFloat(String arg0) {
        return this.wrappedConfiguration.getFloat(arg0);
    }

    public float getFloat(String arg0, float arg1) {
        return this.wrappedConfiguration.getFloat(arg0, arg1);
    }

    public Float getFloat(String arg0, Float arg1) {
        return this.wrappedConfiguration.getFloat(arg0, arg1);
    }

    public int getInt(String arg0) {
        return this.wrappedConfiguration.getInt(arg0);
    }

    public int getInt(String arg0, int arg1) {
        return this.wrappedConfiguration.getInt(arg0, arg1);
    }

    public Integer getInteger(String arg0, Integer arg1) {
        return this.wrappedConfiguration.getInteger(arg0, arg1);
    }

    public long getLong(String arg0) {
        return this.wrappedConfiguration.getLong(arg0);
    }

    public long getLong(String arg0, long arg1) {
        return this.wrappedConfiguration.getLong(arg0, arg1);
    }

    public Long getLong(String arg0, Long arg1) {
        return this.wrappedConfiguration.getLong(arg0, arg1);
    }

    public short getShort(String arg0) {
        return this.wrappedConfiguration.getShort(arg0);
    }

    public short getShort(String arg0, short arg1) {
        return this.wrappedConfiguration.getShort(arg0, arg1);
    }

    public Short getShort(String arg0, Short arg1) {
        return this.wrappedConfiguration.getShort(arg0, arg1);
    }

    public BigDecimal getBigDecimal(String arg0) {
        return this.wrappedConfiguration.getBigDecimal(arg0);
    }

    public BigDecimal getBigDecimal(String arg0, BigDecimal arg1) {
        return this.wrappedConfiguration.getBigDecimal(arg0, arg1);
    }

    public BigInteger getBigInteger(String arg0) {
        return this.wrappedConfiguration.getBigInteger(arg0);
    }

    public BigInteger getBigInteger(String arg0, BigInteger arg1) {
        return this.wrappedConfiguration.getBigInteger(arg0, arg1);
    }

    public String getString(String arg0) {
        return this.wrappedConfiguration.getString(arg0);
    }

    public String getString(String arg0, String arg1) {
        return this.wrappedConfiguration.getString(arg0, arg1);
    }

    public String[] getStringArray(String arg0) {
        return this.wrappedConfiguration.getStringArray(arg0);
    }

    public List<Object> getList(String arg0) {
        return this.wrappedConfiguration.getList(arg0);
    }

    public List<Object> getList(String arg0, List<?> arg1) {
        return this.wrappedConfiguration.getList(arg0, arg1);
    }

    @Override
    public int size() {
        return this.getAsProperties().size();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.getAsProperties().containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.getAsProperties().containsValue(arg0);
    }

    @Override
    public Object get(Object arg0) {
        return this.getAsProperties().get(arg0);
    }

    @Override
    public Object put(Object arg0, Object arg1) {
        return this.getAsProperties().put(arg0, arg1);
    }

    @Override
    public Object remove(Object arg0) {
        return this.getAsProperties().remove(arg0);
    }

    @Override
    public void putAll(Map<?, ?> arg0) {
        this.getAsProperties().putAll(arg0);
    }

    @Override
    public Set<Object> keySet() {
        return this.getAsProperties().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.getAsProperties().values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.getAsProperties().entrySet();
    }

    @Override
    public Object getOrDefault(Object arg0, Object arg1) {
        return this.getAsProperties().getOrDefault(arg0, arg1);
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> arg0) {
        this.getAsProperties().forEach(arg0);
    }

    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ?> arg0) {
        this.getAsProperties().replaceAll(arg0);
    }

    @Override
    public Object putIfAbsent(Object arg0, Object arg1) {
        return this.getAsProperties().putIfAbsent(arg0, arg1);
    }

    @Override
    public boolean remove(Object arg0, Object arg1) {
        return this.getAsProperties().remove(arg0, arg1);
    }

    @Override
    public boolean replace(Object arg0, Object arg1, Object arg2) {
        return this.getAsProperties().replace(arg0, arg1, arg2);
    }

    @Override
    public Object replace(Object arg0, Object arg1) {
        return this.getAsProperties().replace(arg0, arg1);
    }

    @Override
    public Object computeIfAbsent(Object arg0, Function<? super Object, ?> arg1) {
        return this.getAsProperties().computeIfAbsent(arg0, arg1);
    }

    @Override
    public Object computeIfPresent(Object arg0, BiFunction<? super Object, ? super Object, ?> arg1) {
        return this.getAsProperties().computeIfPresent(arg0, arg1);
    }

    @Override
    public Object compute(Object arg0, BiFunction<? super Object, ? super Object, ?> arg1) {
        return this.getAsProperties().compute(arg0, arg1);
    }

    @Override
    public Object merge(Object arg0, Object arg1, BiFunction<? super Object, ? super Object, ?> arg2) {
        return this.getAsProperties().merge(arg0, arg1, arg2);
    }

    static {
        org.apache.commons.configuration.AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
    }

    private static interface MapExcludedMethodsForDelegation {
        public void clear();

        public boolean isEmpty();
    }
}

