/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.config;

import com.google.common.collect.Maps;
import dev.aherscu.qa.tester.utils.StringUtilsExtensions;
import dev.aherscu.qa.tester.utils.config.AbstractConfiguration;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfiguration
extends AbstractConfiguration<CompositeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BaseConfiguration.class);

    public BaseConfiguration(Configuration ... configurations) {
        super(new CompositeConfiguration(Arrays.asList(configurations)));
        log.trace("configuration loaded {}", (Object)this.toString("\r\n"));
    }

    public Stream<Map<String, String>> groupsOf(String prefix) {
        return this.entrySet().stream().map(entry -> Maps.immutableEntry((Object)entry.getKey().toString(), (Object)entry.getValue().toString())).filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.groupingBy(entry -> StringUtilsExtensions.substringBetween((String)((String)entry.getKey()), (String)prefix, (String)"."))).values().stream().map(groupedEntries -> groupedEntries.stream().collect(Collectors.toMap(groupedEntry -> StringUtilsExtensions.substringAfter((String)StringUtilsExtensions.substringAfter((String)((String)groupedEntry.getKey()), (String)prefix), (String)"."), Map.Entry::getValue)));
    }

    public String toString(CharSequence delimiter) {
        return this.entrySet().stream().map(Object::toString).map(s -> StringUtilsExtensions.abbreviate(s, 127)).sorted().collect(Collectors.joining(delimiter));
    }

    public String toString() {
        return this.toString(";");
    }
}

