/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.logging;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;

@SuppressFBWarnings(value={"LO_SUSPECT_LOG_PARAMETER"})
class LoggingStreamHelper<S extends Closeable>
implements Closeable {
    protected final S tee;
    private final OutputStream logOutputStream = new ByteArrayOutputStream();
    private final Consumer<String> logger;

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    LoggingStreamHelper(S stream, Consumer<String> logger) {
        if (stream instanceof OutputStream) {
            this.tee = new TeeOutputStream((OutputStream)stream, this.logOutputStream);
        } else if (stream instanceof InputStream) {
            this.tee = new TeeInputStream((InputStream)stream, this.logOutputStream);
        } else {
            throw new ClassCastException("OutputStream or InputStream derivative expected");
        }
        this.logger = logger;
    }

    @Override
    public void close() throws IOException {
        this.logger.accept(this.logOutputStream.toString());
        this.logOutputStream.close();
        this.tee.close();
    }
}

