/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.pooling;

import dev.aherscu.qa.tester.utils.pooling.AutoReturnable;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AutoReturnableObjectFactory<T>
extends BasePooledObjectFactory<AutoReturnable<T>> {
    private static final Logger log = LoggerFactory.getLogger(AutoReturnableObjectFactory.class);
    public final List<T> objects;
    private int index = 0;

    public AutoReturnableObjectFactory(List<T> objects) {
        if (0 == objects.size()) {
            throw new IllegalArgumentException("objects list cannot be empty");
        }
        objects.forEach(object -> log.trace("initiating pool with {}->{}", (Object)object.hashCode(), object));
        this.objects = Collections.unmodifiableList(objects);
    }

    public final synchronized AutoReturnable<T> create() throws Exception {
        if (this.index < this.objects.size()) {
            AutoReturnable<T> object = new AutoReturnable<T>(this.objects.get(this.index));
            log.debug("object #{} added to pool {}", (Object)this.index, (Object)object.$.toString());
            ++this.index;
            return object;
        }
        log.error("index {} must be lower than total available objects {}", (Object)this.index, (Object)this.objects.size());
        throw new Exception("internal error; should not happen");
    }

    public final PooledObject<AutoReturnable<T>> wrap(AutoReturnable<T> obj) {
        return new DefaultPooledObject(obj);
    }
}

