/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.pooling;

import dev.aherscu.qa.tester.utils.pooling.AutoReturnable;
import dev.aherscu.qa.tester.utils.pooling.AutoReturnableObjectFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoReturnableObjectPool<T>
extends GenericObjectPool<AutoReturnable<T>> {
    private static final Logger log = LoggerFactory.getLogger(AutoReturnableObjectPool.class);
    private static final ConcurrentHashMap<Class<?>, AutoReturnableObjectPool<?>> POOLS = new ConcurrentHashMap();

    public AutoReturnableObjectPool(AutoReturnableObjectFactory<T> factory) {
        super(factory);
        int total = factory.objects.size();
        log.debug("setting total pooled objects to {} in pool {}", (Object)total, (Object)((Object)((Object)this)).hashCode());
        this.setMaxTotal(total);
        this.setMaxIdle(-1);
    }

    public static <T> AutoReturnableObjectPool<T> poolFor(List<T> availableObjects) {
        if (availableObjects.isEmpty()) {
            throw new IllegalArgumentException("available objects list must contain at least one item");
        }
        return new AutoReturnableObjectPool<T>(new AutoReturnableObjectFactory<T>(availableObjects));
    }

    public static <T> AutoReturnableObjectPool<T> singletonPoolFor(List<T> availableObjects) {
        if (availableObjects.isEmpty()) {
            throw new IllegalArgumentException("available objects list must contain at least one item");
        }
        return POOLS.computeIfAbsent(availableObjects.get(0).getClass(), clazz -> AutoReturnableObjectPool.poolFor(availableObjects));
    }

    public AutoReturnable<T> borrowObject() throws Exception {
        AutoReturnable pooledObject = (AutoReturnable)super.borrowObject();
        log.trace("borrowing object {}", (Object)pooledObject.$.toString());
        pooledObject.pool = this;
        return pooledObject;
    }
}

