/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.rest;

import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class AuthenticationRequestFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationRequestFilter.class);
    private final String user;
    private final String password;

    public void filter(ClientRequestContext requestContext) {
        log.debug("adding basic authentication {}", (Object)this.basicAuthentication());
        requestContext.getHeaders().add((Object)"Authorization", (Object)this.basicAuthentication());
    }

    protected String basicAuthentication() {
        return "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", this.user, this.password).getBytes(StandardCharsets.UTF_8));
    }

    public AuthenticationRequestFilter(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public String toString() {
        return "AuthenticationRequestFilter(user=" + this.user + ", password=" + this.password + ")";
    }
}

