/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.rest;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProvider;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClientBuilder;
import com.amazonaws.services.cognitoidp.model.AuthFlowType;
import com.amazonaws.services.cognitoidp.model.ChallengeNameType;
import com.amazonaws.services.cognitoidp.model.InitiateAuthRequest;
import com.amazonaws.services.cognitoidp.model.InitiateAuthResult;
import com.amazonaws.services.cognitoidp.model.RespondToAuthChallengeRequest;
import com.amazonaws.services.cognitoidp.model.RespondToAuthChallengeResult;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.aherscu.qa.tester.utils.StringUtilsExtensions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"USBR_UNNECESSARY_STORE_BEFORE_RETURN"}, justification="hashcode implemented by lombok")
public class AwsCognitoSrpAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(AwsCognitoSrpAuthenticator.class);
    private static final String HEX_N = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF";
    private static final BigInteger N = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
    private static final BigInteger g = BigInteger.valueOf(2L);
    private static final Pair<BigInteger, BigInteger> aA = AwsCognitoSrpAuthenticator.aA(N, g);
    private static final Cache<CachingKey, RespondToAuthChallengeResult> cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(Long.parseLong(System.getProperty("authentication.caching.minutes", "10")))).build();
    private final Algorithm algorithm;
    private final String clientId;
    private final Regions region;
    private final String secretKey;
    private final String userPoolId;

    private static Pair<BigInteger, BigInteger> aA(BigInteger N, BigInteger g) {
        BigInteger a;
        BigInteger A;
        while ((A = g.modPow(a = new BigInteger(1024, AwsCognitoSrpAuthenticator.sha1PRNG()).mod(N), N)).mod(N).equals(BigInteger.ZERO)) {
        }
        return Pair.of((Object)a, (Object)A);
    }

    private static Format challengeTimeFormat() {
        SimpleDateFormat formatTimestamp = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
        formatTimestamp.setTimeZone(new SimpleTimeZone(2, "UTC"));
        return formatTimestamp;
    }

    private static BigInteger k(BigInteger N, BigInteger g) {
        return new BigInteger(1, AwsCognitoSrpAuthenticator.messageFor(N.toByteArray(), g.toByteArray()));
    }

    public static void main(String[] args) {
        System.out.println("HTTPS_PROXY=" + System.getenv("HTTPS_PROXY"));
        System.out.println("JRE Path: " + System.getProperty("java.home"));
        Options options = new Options();
        options.addRequiredOption("p", "pool", true, "User pool ID");
        options.addRequiredOption("c", "client", true, "Client ID");
        options.addRequiredOption("r", "region", true, "Region ID");
        options.addRequiredOption("u", "username", true, "User name");
        options.addRequiredOption("s", "secret", true, "User secret password");
        try {
            CommandLine commandLine = new DefaultParser().parse(options, args);
            String token = AwsCognitoSrpAuthenticator.builder().region(Regions.fromName((String)commandLine.getOptionValue("region"))).clientId(commandLine.getOptionValue("client")).userPoolId(commandLine.getOptionValue("pool")).build().authChallengeResultWithoutCaching(commandLine.getOptionValue("username"), commandLine.getOptionValue("secret")).getAuthenticationResult().getIdToken();
            System.out.println(">>>");
            System.out.println(token);
            System.out.println("<<<");
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("ERROR >>> " + t.getMessage());
            new HelpFormatter().printHelp("aws-cognito-srp-authenticator", options);
            System.exit(-1);
        }
    }

    private static byte[] messageFor(byte[] ... byteArrays) {
        MessageDigest messageDigest = AwsCognitoSrpAuthenticator.sha256Digest();
        for (byte[] byteArray : byteArrays) {
            messageDigest.update(byteArray);
        }
        return messageDigest.digest();
    }

    private static SecureRandom sha1PRNG() {
        return SecureRandom.getInstance("SHA1PRNG");
    }

    private static MessageDigest sha256Digest() {
        return MessageDigest.getInstance("SHA-256");
    }

    private static BigInteger u(BigInteger B, Pair<BigInteger, BigInteger> aA) {
        BigInteger u = new BigInteger(1, AwsCognitoSrpAuthenticator.messageFor(((BigInteger)aA.getRight()).toByteArray(), B.toByteArray()));
        if (u.equals(BigInteger.ZERO)) {
            throw new SecurityException("Hash of A and B cannot be zero");
        }
        return u;
    }

    private static byte[] utf8BytesFrom(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private static String utf8StringFrom(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public RespondToAuthChallengeResult authChallengeResult(String userName, String password) {
        return (RespondToAuthChallengeResult)cache.get((Object)new CachingKey(this, userName, password), () -> this.authChallengeResultWithoutCaching(userName, password));
    }

    public RespondToAuthChallengeResult authChallengeResultWithoutCaching(String userName, String password) {
        log.debug("retrieving authentication challenge result for {} with {}:{}", new Object[]{this, userName, password});
        AWSCognitoIdentityProvider cognitoIdentityProvider = this.cognitoIdentityProvider();
        InitiateAuthResult initiateAuthResult = cognitoIdentityProvider.initiateAuth(this.initiateUserSrpAuthRequest(userName));
        if (!ChallengeNameType.PASSWORD_VERIFIER.toString().equals(initiateAuthResult.getChallengeName())) {
            throw new SecurityException("challenge failed");
        }
        return cognitoIdentityProvider.respondToAuthChallenge(this.respondToAuthChallengeRequest(new AuthenticationChallenge(initiateAuthResult), password));
    }

    protected AWSCognitoIdentityProvider cognitoIdentityProvider() {
        return (AWSCognitoIdentityProvider)((AWSCognitoIdentityProviderClientBuilder)((AWSCognitoIdentityProviderClientBuilder)AWSCognitoIdentityProviderClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).withRegion(this.region)).build();
    }

    private byte[] getPasswordAuthenticationKey(String userId, String userPassword, BigInteger B, BigInteger salt) {
        BigInteger x = this.x(userId, userPassword, salt);
        BigInteger S = B.subtract(AwsCognitoSrpAuthenticator.k(N, g).multiply(g.modPow(x, N))).modPow(((BigInteger)aA.getLeft()).add(AwsCognitoSrpAuthenticator.u(B, aA).multiply(x)), N).mod(N);
        return new Hkdf(S.toByteArray(), AwsCognitoSrpAuthenticator.u(B, aA).toByteArray()).deriveKey();
    }

    private Mac initHmacSha256With(Key key) {
        Mac mac = Mac.getInstance(this.algorithm.name());
        mac.init(key);
        return mac;
    }

    private InitiateAuthRequest initiateUserSrpAuthRequest(String userName) {
        InitiateAuthRequest initiateAuthRequest = new InitiateAuthRequest();
        initiateAuthRequest.setAuthFlow(AuthFlowType.USER_SRP_AUTH);
        initiateAuthRequest.setClientId(this.clientId);
        if (StringUtilsExtensions.isNotBlank((CharSequence)this.secretKey)) {
            initiateAuthRequest.addAuthParametersEntry("SECRET_HASH", this.secretHashFor(new SecretKeySpec(AwsCognitoSrpAuthenticator.utf8BytesFrom(this.secretKey), this.algorithm.name()), userName));
        }
        initiateAuthRequest.addAuthParametersEntry("USERNAME", userName);
        initiateAuthRequest.addAuthParametersEntry("SRP_A", ((BigInteger)aA.getRight()).toString(16));
        return initiateAuthRequest;
    }

    private byte[] macFor(Key key, byte[] ... byteArrays) {
        Mac mac = this.initHmacSha256With(key);
        for (byte[] byteArray : byteArrays) {
            mac.update(byteArray);
        }
        return mac.doFinal();
    }

    private RespondToAuthChallengeRequest respondToAuthChallengeRequest(final AuthenticationChallenge challenge, final String password) {
        final String timestamp = AwsCognitoSrpAuthenticator.challengeTimeFormat().format(new Date());
        RespondToAuthChallengeRequest respondToAuthChallengeRequest = new RespondToAuthChallengeRequest();
        respondToAuthChallengeRequest.setClientId(this.clientId);
        respondToAuthChallengeRequest.setSession(challenge.session());
        respondToAuthChallengeRequest.setChallengeName(challenge.name());
        respondToAuthChallengeRequest.setChallengeResponses((Map)new HashMap<String, String>(){
            {
                this.put("PASSWORD_CLAIM_SECRET_BLOCK", challenge.secretBlock());
                this.put("USERNAME", challenge.username());
                this.put("TIMESTAMP", timestamp);
                this.put("PASSWORD_CLAIM_SIGNATURE", AwsCognitoSrpAuthenticator.utf8StringFrom(Base64.getEncoder().encode(AwsCognitoSrpAuthenticator.this.macFor(new SecretKeySpec(AwsCognitoSrpAuthenticator.this.getPasswordAuthenticationKey(challenge.userIdForSRP(), password, challenge.srpB(), challenge.salt()), AwsCognitoSrpAuthenticator.this.algorithm.name()), new byte[][]{AwsCognitoSrpAuthenticator.this.userPoolIdNoise(), AwsCognitoSrpAuthenticator.utf8BytesFrom(challenge.userIdForSRP()), Base64.getDecoder().decode(challenge.secretBlock()), AwsCognitoSrpAuthenticator.utf8BytesFrom(timestamp)}))));
            }
        });
        return respondToAuthChallengeRequest;
    }

    private String secretHashFor(Key key, String userName) {
        return Base64.getEncoder().encodeToString(this.macFor(key, AwsCognitoSrpAuthenticator.utf8BytesFrom(userName), AwsCognitoSrpAuthenticator.utf8BytesFrom(this.clientId)));
    }

    private byte[] userIdHash(String userId, String userPassword) {
        return AwsCognitoSrpAuthenticator.messageFor(this.userPoolIdNoise(), AwsCognitoSrpAuthenticator.utf8BytesFrom(userId), AwsCognitoSrpAuthenticator.utf8BytesFrom(":"), AwsCognitoSrpAuthenticator.utf8BytesFrom(userPassword));
    }

    private byte[] userPoolIdNoise() {
        return AwsCognitoSrpAuthenticator.utf8BytesFrom(StringUtilsExtensions.substringAfter((String)this.userPoolId, (String)"_"));
    }

    private BigInteger x(String userId, String userPassword, BigInteger salt) {
        return new BigInteger(1, AwsCognitoSrpAuthenticator.messageFor(salt.toByteArray(), this.userIdHash(userId, userPassword)));
    }

    private static Algorithm $default$algorithm() {
        return Algorithm.HMACSHA256;
    }

    AwsCognitoSrpAuthenticator(Algorithm algorithm, String clientId, Regions region, String secretKey, String userPoolId) {
        this.algorithm = algorithm;
        this.clientId = clientId;
        this.region = region;
        this.secretKey = secretKey;
        this.userPoolId = userPoolId;
    }

    public static AwsCognitoSrpAuthenticatorBuilder builder() {
        return new AwsCognitoSrpAuthenticatorBuilder();
    }

    public String toString() {
        return "AwsCognitoSrpAuthenticator(clientId=" + this.clientId + ", region=" + this.region + ", secretKey=" + this.secretKey + ", userPoolId=" + this.userPoolId + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsCognitoSrpAuthenticator)) {
            return false;
        }
        AwsCognitoSrpAuthenticator other = (AwsCognitoSrpAuthenticator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Algorithm this$algorithm = this.algorithm;
        Algorithm other$algorithm = other.algorithm;
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        String this$clientId = this.clientId;
        String other$clientId = other.clientId;
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        Regions this$region = this.region;
        Regions other$region = other.region;
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$secretKey = this.secretKey;
        String other$secretKey = other.secretKey;
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$userPoolId = this.userPoolId;
        String other$userPoolId = other.userPoolId;
        return !(this$userPoolId == null ? other$userPoolId != null : !this$userPoolId.equals(other$userPoolId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AwsCognitoSrpAuthenticator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Algorithm $algorithm = this.algorithm;
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        String $clientId = this.clientId;
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        Regions $region = this.region;
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $secretKey = this.secretKey;
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $userPoolId = this.userPoolId;
        result = result * 59 + ($userPoolId == null ? 43 : $userPoolId.hashCode());
        return result;
    }

    public static class AwsCognitoSrpAuthenticatorBuilder {
        private boolean algorithm$set;
        private Algorithm algorithm$value;
        private String clientId;
        private Regions region;
        private String secretKey;
        private String userPoolId;

        AwsCognitoSrpAuthenticatorBuilder() {
        }

        public AwsCognitoSrpAuthenticatorBuilder algorithm(Algorithm algorithm) {
            this.algorithm$value = algorithm;
            this.algorithm$set = true;
            return this;
        }

        public AwsCognitoSrpAuthenticatorBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AwsCognitoSrpAuthenticatorBuilder region(Regions region) {
            this.region = region;
            return this;
        }

        public AwsCognitoSrpAuthenticatorBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public AwsCognitoSrpAuthenticatorBuilder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public AwsCognitoSrpAuthenticator build() {
            Algorithm algorithm$value = this.algorithm$value;
            if (!this.algorithm$set) {
                algorithm$value = AwsCognitoSrpAuthenticator.$default$algorithm();
            }
            return new AwsCognitoSrpAuthenticator(algorithm$value, this.clientId, this.region, this.secretKey, this.userPoolId);
        }

        public String toString() {
            return "AwsCognitoSrpAuthenticator.AwsCognitoSrpAuthenticatorBuilder(algorithm$value=" + (Object)((Object)this.algorithm$value) + ", clientId=" + this.clientId + ", region=" + this.region + ", secretKey=" + this.secretKey + ", userPoolId=" + this.userPoolId + ")";
        }
    }

    @SuppressFBWarnings(value={"IMA_INEFFICIENT_MEMBER_ACCESS"}, justification="no real performance impact as this class does I/O")
    final class Hkdf {
        static final String DERIVED_KEY_INFO = "Caldera Derived Key";
        static final int DERIVED_KEY_SIZE = 16;
        static final int MAX_KEY_SIZE = 255;
        final byte[] EMPTY_ARRAY = new byte[0];
        final SecretKey privateKey;

        Hkdf(byte[] ikm, byte[] salt) {
            this.privateKey = new SecretKeySpec(AwsCognitoSrpAuthenticator.this.initHmacSha256With(new SecretKeySpec(salt, AwsCognitoSrpAuthenticator.this.algorithm.name())).doFinal(ikm), AwsCognitoSrpAuthenticator.this.algorithm.name());
        }

        byte[] deriveKey() {
            return this.deriveKey(AwsCognitoSrpAuthenticator.utf8BytesFrom(DERIVED_KEY_INFO), 16);
        }

        byte[] deriveKey(byte[] info, int length) {
            byte[] result = new byte[length];
            Mac mac = AwsCognitoSrpAuthenticator.this.initHmacSha256With(this.privateKey);
            if (length > 255 * mac.getMacLength()) {
                throw new IllegalArgumentException("Requested keys may not be longer than 255 times the underlying HMAC length.");
            }
            byte[] t = this.EMPTY_ARRAY;
            int loc = 0;
            byte i = 1;
            while (loc < length) {
                mac.update(t);
                mac.update(info);
                mac.update(i);
                t = mac.doFinal();
                for (int x = 0; x < t.length && loc < length; ++x, ++loc) {
                    result[loc] = t[x];
                }
                i = (byte)(i + 1);
            }
            return result;
        }
    }

    @SuppressFBWarnings(value={"USBR_UNNECESSARY_STORE_BEFORE_RETURN"}, justification="hashcode implemented by lombok")
    static class CachingKey {
        final AwsCognitoSrpAuthenticator authenticator;
        final String userName;
        final String password;

        public CachingKey(AwsCognitoSrpAuthenticator authenticator, String userName, String password) {
            this.authenticator = authenticator;
            this.userName = userName;
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachingKey)) {
                return false;
            }
            CachingKey other = (CachingKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AwsCognitoSrpAuthenticator this$authenticator = this.authenticator;
            AwsCognitoSrpAuthenticator other$authenticator = other.authenticator;
            if (this$authenticator == null ? other$authenticator != null : !((Object)this$authenticator).equals(other$authenticator)) {
                return false;
            }
            String this$userName = this.userName;
            String other$userName = other.userName;
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$password = this.password;
            String other$password = other.password;
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CachingKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AwsCognitoSrpAuthenticator $authenticator = this.authenticator;
            result = result * 59 + ($authenticator == null ? 43 : ((Object)$authenticator).hashCode());
            String $userName = this.userName;
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $password = this.password;
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }
    }

    static final class AuthenticationChallenge {
        private final InitiateAuthResult challenge;

        String name() {
            return this.challenge.getChallengeName();
        }

        BigInteger salt() {
            return new BigInteger((String)this.challenge.getChallengeParameters().get("SALT"), 16);
        }

        String secretBlock() {
            return (String)this.challenge.getChallengeParameters().get("SECRET_BLOCK");
        }

        String session() {
            return this.challenge.getSession();
        }

        BigInteger srpB() {
            BigInteger srpB = new BigInteger((String)this.challenge.getChallengeParameters().get("SRP_B"), 16);
            if (srpB.mod(N).equals(BigInteger.ZERO)) {
                throw new SecurityException("SRP error, B cannot be zero");
            }
            return srpB;
        }

        String userIdForSRP() {
            return (String)this.challenge.getChallengeParameters().get("USER_ID_FOR_SRP");
        }

        String username() {
            return (String)this.challenge.getChallengeParameters().get("USERNAME");
        }

        public AuthenticationChallenge(InitiateAuthResult challenge) {
            this.challenge = challenge;
        }
    }

    public static enum Algorithm {
        HMACSHA256;

    }
}

