/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.ThreadSafe;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OAuthRequestFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(OAuthRequestFilter.class);
    private final URI refreshTokenUri;

    public OAuthRequestFilter(URI refreshTokenUri) {
        this.refreshTokenUri = refreshTokenUri.normalize();
    }

    public final void filter(ClientRequestContext requestContext) throws IOException {
        String retrievedTokenBlock = this.retrieveTokenBlockFrom(this.refreshTokenUri);
        log.trace("retrieved token block {}", (Object)retrievedTokenBlock);
        String parsedAccessToken = this.parseAccessTokenFrom(retrievedTokenBlock);
        log.trace("parsed access token {}", (Object)parsedAccessToken);
        requestContext.getHeaders().add((Object)"Authorization", (Object)String.format("Bearer %s", parsedAccessToken));
    }

    protected String parseAccessTokenFrom(String token) {
        return (String)JsonPath.parse((String)token).read("$.access_token", new Predicate[0]);
    }

    protected String retrieveTokenBlockFrom(URI url) throws IOException {
        return IOUtils.toString((URI)url, (Charset)StandardCharsets.UTF_8);
    }
}

