/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.supermachine;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class Scanner<T> {
    private final Stream<T> stream;

    protected Scanner(Stream<T> source) {
        this.stream = source;
    }

    public <X> Scanner<X> extract(Function<T, X> extractor) {
        return this.create(this.stream.flatMap(x -> {
            Object result = extractor.apply(x);
            return result != null ? Stream.of(result) : Stream.empty();
        }));
    }

    public Scanner<T> filter(Predicate<T> predicate) {
        return this.create(this.stream.filter(predicate));
    }

    public <X> Scanner<X> find(Class<X> clazz) {
        return this.walk(clazz);
    }

    public Stream<T> stream() {
        return this.stream;
    }

    @SafeVarargs
    public final <X> Scanner<X> then(Function<Scanner<T>, Scanner<X>> ... fns) {
        return this.create(this.stream.flatMap(x -> Stream.of(fns).map(fn -> ((Scanner)fn.apply(this.create(Stream.of(x)))).stream()).reduce(Stream.empty(), Stream::concat)));
    }

    public <X> Scanner<X> walk(Class<X> clazz) {
        Stream<Object> filteredStream = this.stream.filter((? super T x) -> clazz.isAssignableFrom(x.getClass()));
        return this.create(filteredStream);
    }

    protected abstract <X> Scanner<X> create(Stream<X> var1);
}

