/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.supermachine.traverser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ReflectionUtils {
    private static final Map<Class, Collection<Field>> _reflectedFields = new ConcurrentHashMap<Class, Collection<Field>>();

    private ReflectionUtils() {
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE", "DP_DO_INSIDE_DO_PRIVILEGED"}, justification="library code")
    public static void getDeclaredFields(Class c, Collection<Field> fields) {
        try {
            Field[] local;
            for (Field field : local = c.getDeclaredFields()) {
                int modifiers;
                if (!field.isAccessible()) {
                    try {
                        field.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Modifier.isStatic(modifiers = field.getModifiers()) || field.getName().startsWith("this$") || Modifier.isTransient(modifiers)) continue;
                fields.add(field);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Collection<Field> getDeepDeclaredFields(Class c) {
        if (_reflectedFields.containsKey(c)) {
            return _reflectedFields.get(c);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class curr = c; curr != null; curr = curr.getSuperclass()) {
            ReflectionUtils.getDeclaredFields(curr, fields);
        }
        _reflectedFields.put(c, fields);
        return fields;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public static Method getMethod(Class c, String method, Class ... types) {
        try {
            return c.getMethod(method, types);
        }
        catch (Exception nse) {
            return null;
        }
    }
}

