/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.yaml;

import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractYamlStream<T>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractYamlStream.class);
    protected final T yamlStream;

    AbstractYamlStream(T yamlStream) {
        if (!AbstractYamlStream.isLegal(yamlStream)) {
            throw new IllegalArgumentException(MessageFormat.format("{0}", yamlStream));
        }
        this.yamlStream = yamlStream;
    }

    private static boolean isLegal(Object yamlStream) {
        return AbstractYamlStream.isReader(yamlStream) || AbstractYamlStream.isWriter(yamlStream);
    }

    private static boolean isReader(Object yamlStream) {
        return yamlStream instanceof YamlReader;
    }

    private static boolean isWriter(Object yamlStream) {
        return yamlStream instanceof YamlWriter;
    }

    private static <T> T self(Class<T> type, Object obj) {
        return type.cast(obj);
    }

    @Override
    public final void close() throws IOException {
        log.debug("closing YAML stream {}", this.yamlStream);
        if (AbstractYamlStream.isReader(this.yamlStream)) {
            AbstractYamlStream.self(YamlReader.class, this.yamlStream).close();
            return;
        }
        if (AbstractYamlStream.isWriter(this.yamlStream)) {
            AbstractYamlStream.self(YamlWriter.class, this.yamlStream).close();
            return;
        }
        throw new InternalError();
    }
}

