/*
 * Decompiled with CFR 0.152.
 */
package dev.aherscu.qa.tester.utils.yaml;

import com.esotericsoftware.yamlbeans.YamlException;
import dev.aherscu.qa.tester.utils.FileUtilsExtensions;
import dev.aherscu.qa.tester.utils.yaml.AbstractYamlStream;
import dev.aherscu.qa.tester.utils.yaml.L10N;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlReader<T>
extends AbstractYamlStream<com.esotericsoftware.yamlbeans.YamlReader> {
    private static final Logger log = LoggerFactory.getLogger(YamlReader.class);

    public YamlReader(File from) throws IOException {
        this(FileUtilsExtensions.fileReader(from));
        log.debug("creating YAML reader {} for {}", this, (Object)from.toString());
    }

    public YamlReader(Reader reader) {
        super(new com.esotericsoftware.yamlbeans.YamlReader(reader));
    }

    public T read(Class<T> type) throws YamlException {
        log.debug("using YAML reader {} on type {}", (Object)this, (Object)type.getName());
        Object object = ((com.esotericsoftware.yamlbeans.YamlReader)this.yamlStream).read(type);
        if (null != object) {
            return (T)object;
        }
        throw new YamlException(L10N.MESSAGES.badYamlFormat());
    }
}

