package dev.atsushieno.ktmidi

object WellKnownNames {
    val ccNames = mapOf(
        // 0-15
        0 to "Bank",
        1 to "Mod.Wheel",
        2 to "Breath",
        4 to "FootPedal",
        5 to "Port.Time",
        6 to "DTE",
        7 to "Volume",
        8 to "Balance",
        10 to "Pan",
        11 to "Expression",
        12 to "Effect1",
        13 to "Effect2",
        // 16-31
        16 to "Slider",
        17 to "Knob",
        18 to "Ribbon",
        // 32-63
        32 to "Bank LSB",
        33 to "Mod. LSB",
        34 to "Breath LSB",
        36 to "Foot LSB",
        37 to "Port.Time LSB",
        38 to "DTE LSB",
        39 to "Volume LSB",
        40 to "Balance LSB",
        42 to "Pan LSB",
        43 to "Expr. LSB",
        44 to "Efx1 LSB",
        45 to "Efx2 LSB",
        // 64-79
        64 to "Sustain",
        65 to "Portamento",
        66 to "Sostenuto",
        67 to "SoftPedal",
        68 to "Legato",
        69 to "HoldPedal2",
        70 to "Ctrl. 1",
        71 to "Ctrl. 2",
        72 to "Ctrl. 3",
        73 to "Ctrl. 4",
        74 to "Ctrl. 5",
        75 to "Ctrl. 6",
        76 to "Ctrl. 7",
        77 to "Ctrl. 8",
        78 to "Ctrl. 9",
        79 to "Ctrl. 10",
        // 80-95
        80 to "General1",
        81 to "General2",
        82 to "General3",
        83 to "General4",
        84 to "General5",
        91 to "Efx1 Depth",
        92 to "Efx2 Depth",
        93 to "Efx3 Depth",
        94 to "Efx4 Depth",
        95 to "Efx5 Depth",
        // 96-120
        96 to "Data +",
        97 to "Data -",
        98 to "NRPN",
        99 to "NRPN LSB",
        100 to "RPN",
        101 to "RPN LSB",
        // 120-127
        120 to "Chan. Mute",
        121 to "Reset All",
        122 to "Local Key",
        123 to "All Notes",
        124 to "Omni OFF",
        125 to "Omni ON",
        126 to "Mono Mode",
        127 to "Poly Mode"
    )
    val ccFullNames = mapOf(
        // 0-15
        0 to "Bank Select",
        1 to "Modulation Wheel",
        2 to "Breath Controller",
        4 to "Foot Pedal",
        5 to "Portament Time",
        6 to "Data Entry",
        7 to "Volume",
        8 to "Balance",
        10 to "Pan",
        11 to "Expression Pedal",
        12 to "Effect Control 1",
        13 to "Effect Control 2",
        // 16-31
        16 to "Slider",
        17 to "Knob",
        18 to "Ribbon",
        // 32-63
        32 to "Bank Select LSB",
        33 to "Modulation Wheel LSB",
        34 to "Breath Controller LSB",
        36 to "Foot Pedal LSB",
        37 to "Portament Time LSB",
        38 to "Data Entry LSB",
        39 to "Volume LSB",
        40 to "Balance LSB",
        42 to "Pan LSB",
        43 to "Expression LSB",
        44 to "Effect Control 1 LSB",
        45 to "Effect Control 2 LSB",
        // 64-79
        64 to "Sustain Pedal",
        65 to "Portamento",
        66 to "Sostenuto",
        67 to "Soft Pedal",
        68 to "Legato",
        69 to "Hold Pedal 2",
        70 to "Sound Controller 1",
        71 to "Sound Controller 2",
        72 to "Sound Controller 3",
        73 to "Sound Controller 4",
        74 to "Sound Controller 5",
        75 to "Sound Controller 6",
        76 to "Sound Controller 7",
        77 to "Sound Controller 8",
        78 to "Sound Controller 9",
        79 to "Sound Controller 10",
        // 80-95
        80 to "General Purpose 1",
        81 to "General Purpose 2",
        82 to "General Purpose 3",
        83 to "General Purpose 4",
        84 to "General Purpose 5",
        91 to "Effect 1 Depth",
        92 to "Effect 2 Depth",
        93 to "Effect 3 Depth",
        94 to "Effect 4 Depth",
        95 to "Effect 5 Depth",
        // 96-120
        96 to "Data Bound Increment",
        97 to "Data Bound Decrement",
        98 to "NRPN",
        99 to "NRPN LSB",
        100 to "RPN",
        101 to "RPN LSB",
        // 120-127
        120 to "Channel Mute",
        121 to "Reset All Controllers",
        122 to "Local Keyboard",
        123 to "All Notes",
        124 to "Omni Mode OFF",
        125 to "Omni Mode ON",
        126 to "Mono Mode",
        127 to "Poly Mode"
    )
}