package net.binis.codegen.spring.modifier.impl;

/*-
 * #%L
 * code-generator-spring
 * %%
 * Copyright (C) 2021 - 2024 Binis Belev
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import lombok.extern.slf4j.Slf4j;
import net.binis.codegen.async.AsyncDispatcher;
import net.binis.codegen.async.executor.CodeExecutor;
import net.binis.codegen.async.executor.impl.BaseAsyncExecutorImpl;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.spring.async.AsyncModifier;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

@Slf4j
public abstract class AsyncEntityModifierImpl<T, R> extends BaseEntityModifierImpl<T, R> {

    static {
        CodeFactory.registerType(AsyncDispatcher.class, CodeFactory.singleton(CodeExecutor.defaultDispatcher()), null);
    }

    protected AsyncEntityModifierImpl(R parent) {
        super(parent);
    }

    public AsyncModifier<T, R> async() {
        return new AsyncImpl();
    }

    protected class AsyncImpl extends BaseAsyncExecutorImpl<AsyncModifier<T, R>, R> implements AsyncModifier<T, R> {

        @Override
        public CompletableFuture<R> save() {
            return internalExecute(AsyncEntityModifierImpl.this::save);
        }

        @Override
        public CompletableFuture<R> delete() {
            return internalExecute(AsyncEntityModifierImpl.this::delete);
        }

        @Override
        public CompletableFuture<R> execute(Consumer<T> task) {
            return internalExecute(() ->
                    AsyncEntityModifierImpl.this.transaction(m -> {
                        task.accept(m);
                        return null;
                    }));
        }

    }

}
